/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matchable;
import fitnesse.wikitext.parser.MatchableFilter;
import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.TextMaker;
import fitnesse.wikitext.parser.VariableSource;
import java.util.ArrayList;
import java.util.List;
import util.Maybe;

public class Scanner {
    private static final Symbol endToken = new Symbol(SymbolType.Empty);
    private ScanString input;
    private Symbol currentToken;
    private int next;
    private TextMaker textMaker;

    public Scanner(SourcePage sourcePage, String input) {
        this.input = new ScanString(input, 0);
        this.next = 0;
        this.textMaker = new TextMaker(new VariableSource(){

            @Override
            public Maybe<String> findVariable(String name) {
                return Maybe.noString;
            }
        }, sourcePage);
    }

    public Scanner(TextMaker textMaker, String input) {
        this.input = new ScanString(input, 0);
        this.next = 0;
        this.textMaker = textMaker;
    }

    public Scanner(Scanner other) {
        this.copy(other);
    }

    public int getOffset() {
        return this.next;
    }

    public void markStart() {
        this.input.markStart(this.next);
    }

    public boolean isEnd() {
        return this.currentToken == endToken;
    }

    public boolean isLast() {
        return this.input.isEnd(1);
    }

    public Symbol getCurrent() {
        return this.currentToken;
    }

    public String stringFromStart(int start) {
        return this.input.rawSubstring(start, this.getOffset() - this.getCurrent().getContent().length());
    }

    public void copy(Scanner other) {
        this.input = new ScanString(other.input);
        this.next = other.next;
        this.currentToken = other.currentToken;
        this.textMaker = other.textMaker;
    }

    public Symbol makeLiteral(SymbolType terminator) {
        this.input.setOffset(this.next);
        while (!this.input.isEnd()) {
            SymbolMatch match = terminator.makeMatch(this.input);
            if (match.isMatch()) {
                Symbol result = new Symbol(SymbolType.Text, this.input.substringFrom(this.next));
                this.next = this.input.getOffset() + match.getMatchLength();
                return result;
            }
            this.input.moveNext();
        }
        Symbol result = new Symbol(SymbolType.Text, this.input.substringFrom(this.next));
        this.next = this.input.getOffset();
        this.currentToken = endToken;
        return result;
    }

    public void moveNext() {
        this.moveNextIgnoreFirst(new ParseSpecification());
    }

    public void moveNextIgnoreFirst(ParseSpecification specification) {
        Step step = this.makeNextStep(specification, this.next);
        this.next = step.nextPosition;
        this.currentToken = step.token;
    }

    public List<Symbol> peek(int count, ParseSpecification specification) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        int startPosition = this.next;
        for (int i = 0; i < count; ++i) {
            Step step = this.makeNextStep(specification, startPosition);
            result.add(step.token);
            if (this.input.isEnd()) break;
            startPosition = step.nextPosition;
        }
        return result;
    }

    private Step makeNextStep(final ParseSpecification specification, final int startPosition) {
        SymbolMatch match;
        this.input.setOffset(startPosition);
        int newNext = startPosition;
        Symbol matchSymbol = null;
        while (!this.input.isEnd()) {
            match = specification.findMatch(this.input, new MatchableFilter(){

                @Override
                public boolean isValid(Matchable candidate) {
                    return Scanner.this.input.getOffset() != startPosition || !specification.ignores(candidate);
                }
            });
            if (match.isMatch()) {
                matchSymbol = match.getSymbol();
                newNext = this.input.getOffset() + match.getMatchLength();
                break;
            }
            this.input.moveNext();
        }
        if (this.input.getOffset() > startPosition) {
            match = this.textMaker.make(specification, this.input.substringFrom(startPosition));
            return new Step(match.getSymbol(), startPosition + match.getMatchLength());
        }
        if (this.input.isEnd()) {
            return new Step(endToken, this.input.getOffset());
        }
        return new Step(matchSymbol, newNext);
    }

    private class Step {
        public Symbol token;
        public int nextPosition;

        public Step(Symbol token, int nextPosition) {
            this.token = token;
            this.nextPosition = nextPosition;
        }
    }
}

