/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkWidget
extends ParentWidget {
    public static final String REGEXP = "https?://[^\\s]+[^\\s.)]+";
    private static final Pattern pattern = Pattern.compile("https?://([^/\\s]*)(\\S*)?");

    public LinkWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        this.addChildWidgets(text);
    }

    @Override
    public String render() throws Exception {
        String linkText = this.childHtml();
        String usableURL = LinkWidget.makeUrlUsable(linkText);
        StringBuffer html = new StringBuffer("<a href=\"");
        html.append(usableURL);
        html.append("\">");
        html.append(linkText);
        html.append("</a>");
        return html.toString();
    }

    public static String makeUrlUsable(String url) {
        String usableUrl = url;
        Matcher match = pattern.matcher(url);
        if (match.find()) {
            String host = match.group(1);
            String resource = match.group(2);
            if ("files".equals(host)) {
                usableUrl = "/files" + resource;
            }
        }
        return usableUrl;
    }

    @Override
    public WidgetBuilder getBuilder() {
        return WidgetBuilder.variableEvaluatorWidgetBuilder;
    }

    @Override
    public String asWikiText() throws Exception {
        return this.childWikiText();
    }
}

