/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableDefinitionWidget
extends ParentWidget {
    public static final String REGEXP = "^!define [\\w\\.]+ +(?:(?:\\{[^}]*\\})|(?:\\([^)]*\\))|(?:\\[[^]]*\\]))";
    private static final Pattern pattern = Pattern.compile("^!define ([\\w\\.]+) +([\\{\\(\\[])(.*)[\\}\\)\\]]", 40);
    public String name;
    public String value;
    public String bracket;

    public VariableDefinitionWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.name = match.group(1);
            this.bracket = match.group(2);
            this.value = match.group(3);
        }
    }

    @Override
    public String render() throws Exception {
        this.parent.addVariable(this.name, this.value);
        return HtmlUtil.metaText("variable defined: " + this.name + "=" + this.value);
    }

    @Override
    public String asWikiText() throws Exception {
        String text = "!define " + this.name + " ";
        text = this.bracket.equals("{") ? text + "{" + this.value + "}" : (this.bracket.equals("(") ? text + "(" + this.value + ")" : text + "[" + this.value + "]");
        return text;
    }
}

