/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import util.FileSystem;

public class MemoryFileSystem
implements FileSystem {
    private final Hashtable<String, String> files = new Hashtable();

    @Override
    public void makeFile(String path, String content) throws IOException {
        this.files.put(path, content);
    }

    @Override
    public void makeDirectory(String path) {
        this.files.put(path, "");
    }

    @Override
    public boolean exists(String path) {
        for (String filePath : this.files.keySet()) {
            if (!filePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] list(String path) {
        ArrayList<String> result = new ArrayList<String>();
        for (String filePath : this.files.keySet()) {
            String newPath;
            if (!filePath.startsWith(path) || filePath.equals(path)) continue;
            String rest = filePath.substring(path.length() + 1);
            int size = rest.indexOf("/");
            if (size < 0) {
                size = rest.length();
            }
            if (result.contains(newPath = rest.substring(0, size))) continue;
            result.add(newPath);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getContent(String path) throws Exception {
        return this.files.get(path);
    }
}

