/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSFactory;
import org.firebirdsql.gds.GDSType;
import org.firebirdsql.gds.isc_db_handle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.FBManagerMBean;

public class FBManager
implements FBManagerMBean {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$management$FBManager == null ? (class$org$firebirdsql$management$FBManager = FBManager.class$("org.firebirdsql.management.FBManager")) : class$org$firebirdsql$management$FBManager, false);
    private GDS gds;
    private DatabaseParameterBuffer c;
    private String host = "localhost";
    private int port = 3050;
    private String fileName;
    private String userName;
    private String password;
    private boolean forceCreate = false;
    private boolean createOnStart = false;
    private boolean dropOnStop = false;
    private String state = "Stopped";
    private static final String STOPPED = "Stopped";
    private static final String STARTED = "Started";
    private GDSType type;
    static /* synthetic */ Class class$org$firebirdsql$management$FBManager;

    public FBManager() {
        this(GDSType.PURE_JAVA);
    }

    public FBManager(GDSType type) {
        this.type = type;
    }

    public void start() throws Exception {
        this.gds = GDSFactory.getGDSForType(this.type);
        this.c = this.gds.newDatabaseParameterBuffer();
        this.c.addArgument(5, new byte[]{90});
        this.c.addArgument(58, new byte[]{120, 10, 0, 0});
        this.c.addArgument(63, new byte[]{3, 0, 0, 0});
        this.state = STARTED;
        if (this.isCreateOnStart()) {
            this.createDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
    }

    public void stop() throws Exception {
        if (this.isDropOnStop()) {
            this.dropDatabase(this.getFileName(), this.getUserName(), this.getPassword());
        }
        this.c = null;
        this.gds.close();
        this.gds = null;
        this.state = STOPPED;
    }

    public String getState() {
        return this.state;
    }

    public String getName() {
        return "Firebird Database manager";
    }

    public void setServer(String host) {
        this.host = host;
    }

    public String getServer() {
        return this.host;
    }

    public String getType() {
        return this.type.toString();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setType(String type) {
        GDSType gdsType = GDSType.getType(type);
        if (gdsType == null) {
            throw new RuntimeException("Unrecognized type '" + type + "'");
        }
        this.type = gdsType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }

    public boolean isForceCreate() {
        return this.forceCreate;
    }

    public void setForceCreate(boolean forceCreate) {
        this.forceCreate = forceCreate;
    }

    public void createDatabase(String fileName, String user, String password) throws Exception {
        DatabaseParameterBuffer dpb;
        isc_db_handle db = null;
        db = this.gds.get_new_isc_db_handle();
        try {
            dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.isc_attach_database(this.getConnectString(fileName), db, dpb);
            if (!this.forceCreate) {
                this.gds.isc_detach_database(db);
                return;
            }
            this.gds.isc_drop_database(db);
        }
        catch (GDSException e) {
            // empty catch block
        }
        db = this.gds.get_new_isc_db_handle();
        try {
            dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.isc_create_database(this.getConnectString(fileName), db, dpb);
            this.gds.isc_detach_database(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception creating database", e);
            }
            throw e;
        }
    }

    public void dropDatabase(String fileName, String user, String password) throws Exception {
        try {
            isc_db_handle db = this.gds.get_new_isc_db_handle();
            DatabaseParameterBuffer dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.isc_attach_database(this.getConnectString(fileName), db, dpb);
            this.gds.isc_drop_database(db);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Exception dropping database", e);
            }
            throw e;
        }
    }

    public boolean isDatabaseExists(String fileName, String user, String password) throws Exception {
        isc_db_handle db = null;
        db = this.gds.get_new_isc_db_handle();
        try {
            DatabaseParameterBuffer dpb = this.c.deepCopy();
            dpb.addArgument(28, user);
            dpb.addArgument(29, password);
            this.gds.isc_attach_database(this.getConnectString(fileName), db, dpb);
            this.gds.isc_detach_database(db);
            return true;
        }
        catch (GDSException e) {
            return false;
        }
    }

    private String getConnectString(String filename) {
        if (this.type == GDSType.NATIVE_EMBEDDED || this.type == GDSType.NATIVE_LOCAL) {
            return filename;
        }
        return this.getServer() + "/" + this.getPort() + ":" + filename;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

