/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import org.zkoss.gmaps.Gmaps;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Ginfo
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200807041526L;
    protected LatLng _anchor = new LatLng(37.4419, -122.1419);
    private String _content = "";
    private boolean _open = false;

    public Ginfo() {
    }

    public Ginfo(String content) {
        this.setContent(content);
    }

    public Ginfo(String content, LatLng anchor) {
        this.setContent(content);
        this.setAnchor(anchor);
    }

    public Ginfo(String content, double lat, double lng) {
        this(content, new LatLng(lat, lng));
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this._content);
        }
    }

    public void setAnchor(double lat, double lng) {
        this.setAnchor(new LatLng(lat, lng));
    }

    public void setAnchor(LatLng anchor) {
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (!Objects.equals((Object)((Object)this._anchor), (Object)((Object)anchor))) {
            this._anchor = anchor;
            this.smartUpdate("anchor", (Object)anchor);
        }
    }

    public LatLng getAnchor() {
        return this._anchor;
    }

    public void setLat(double lat) {
        this.setAnchor(new LatLng(lat, this._anchor.getLongitude()));
    }

    public double getLat() {
        return this._anchor.getLatitude();
    }

    public void setLng(double lng) {
        this.setAnchor(new LatLng(this._anchor.getLatitude(), lng));
    }

    public double getLng() {
        return this._anchor.getLongitude();
    }

    public void setOpen(boolean b) {
        if (this._open != b) {
            Gmaps gmaps = (Gmaps)this.getParent();
            if (gmaps != null) {
                if (b) {
                    gmaps.openInfo(this);
                } else {
                    this.smartUpdate("open", b);
                }
            }
            this._open = b;
        }
    }

    void setOpenByClient(boolean b) {
        this._open = b;
    }

    public boolean isOpen() {
        Gmaps gmaps = (Gmaps)this.getParent();
        return this._open;
    }

    boolean isGinfo() {
        return true;
    }

    public boolean isChildable() {
        return false;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Gmaps)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "anchor", (Object)this._anchor);
        this.render(renderer, "content", this.getContent());
        this.render(renderer, "open", this._open);
    }
}

