/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.HashMap;
import org.zkoss.gmaps.Ginfo;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.event.MapDropEvent;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Gmarker
extends Ginfo {
    private static final long serialVersionUID = 200807041527L;
    public static final int ZOOM_LIMIT = 19;
    private String _iconImage;
    private String _iconShadow;
    private int _iconWidth = -100;
    private int _iconHeight = -100;
    private int _iconShadowWidth = -100;
    private int _iconShadowHeight = -100;
    private int _iconAnchorX = -100;
    private int _iconAnchorY = -100;
    private int _iconInfoAnchorX = -100;
    private int _iconInfoAnchorY = -100;
    private String _iconPrintImage;
    private String _iconMozPrintImage;
    private String _iconPrintShadow;
    private String _iconTransparent;
    private String _iconImageMap;
    private int _iconMaxHeight = -100;
    private String _iconDragCrossImage;
    private int _iconDragCrossWidth = -100;
    private int _iconDragCrossHeight = -100;
    private int _iconDragCrossAnchorX = -100;
    private int _iconDragCrossAnchorY = -100;
    private int _maxzoom = -1;
    private int _minzoom = 0;
    private boolean _draggingEnabled;

    public Gmarker() {
    }

    public Gmarker(String content) {
        super(content);
    }

    public Gmarker(String content, LatLng anchor) {
        super(content, anchor);
    }

    public Gmarker(String content, double lat, double lng) {
        super(content, lat, lng);
    }

    public void setDraggingEnabled(boolean b) {
        if (this._draggingEnabled != b) {
            this._draggingEnabled = b;
            this.smartUpdate("draggingEnabled", b);
        }
    }

    public boolean isDraggingEnabled() {
        return this._draggingEnabled;
    }

    public int getIconAnchorX() {
        return this._iconAnchorX;
    }

    public void setIconAnchorX(int iconAnchorX) {
        if (this._iconAnchorX != iconAnchorX && iconAnchorX > -100) {
            this._iconAnchorX = iconAnchorX;
            this.smartRerender();
        }
    }

    public int getIconAnchorY() {
        return this._iconAnchorY;
    }

    public void setIconAnchorY(int iconAnchorY) {
        if (this._iconAnchorY != iconAnchorY && iconAnchorY > -100) {
            this._iconAnchorY = iconAnchorY;
            this.smartRerender();
        }
    }

    private int[] getIconAnchor() {
        int[] nArray;
        if (this.getIconAnchorX() <= -100 || this.getIconAnchorY() <= -100) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconAnchorX();
            nArray = nArray2;
            nArray2[1] = this.getIconAnchorY();
        }
        return nArray;
    }

    public int getIconDragCrossAnchorX() {
        return this._iconDragCrossAnchorX;
    }

    public void setIconDragCrossAnchorX(int iconDragCrossAnchorX) {
        if (this._iconDragCrossAnchorX != iconDragCrossAnchorX && iconDragCrossAnchorX > -100) {
            this._iconDragCrossAnchorX = iconDragCrossAnchorX;
            this.smartRerender();
        }
    }

    public int getIconDragCrossAnchorY() {
        return this._iconDragCrossAnchorY;
    }

    public void setIconDragCrossAnchorY(int iconDragCrossAnchorY) {
        if (this._iconDragCrossAnchorY != iconDragCrossAnchorY && iconDragCrossAnchorY > -100) {
            this._iconDragCrossAnchorY = iconDragCrossAnchorY;
            this.smartRerender();
        }
    }

    private int[] getIconDragCrossAnchor() {
        int[] nArray;
        if (this.getIconDragCrossAnchorX() < 0 || this.getIconDragCrossAnchorY() < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconDragCrossAnchorX();
            nArray = nArray2;
            nArray2[1] = this.getIconDragCrossAnchorY();
        }
        return nArray;
    }

    public String getIconDragCrossImage() {
        return this._iconDragCrossImage;
    }

    public void setIconDragCrossImage(String iconDragCrossImage) {
        if (iconDragCrossImage != null && !iconDragCrossImage.equals(this._iconDragCrossImage)) {
            this._iconDragCrossImage = iconDragCrossImage;
            this.smartRerender();
        }
    }

    public int getIconDragCrossHeight() {
        return this._iconDragCrossHeight;
    }

    public void setIconDragCrossHeight(int iconDragCrossHeight) {
        if (this._iconDragCrossHeight != iconDragCrossHeight && iconDragCrossHeight >= 0) {
            this._iconDragCrossHeight = iconDragCrossHeight;
            this.smartRerender();
        }
    }

    public int getIconDragCrossWidth() {
        return this._iconDragCrossWidth;
    }

    public void setIconDragCrossWidth(int iconDragCrossWidth) {
        if (this._iconDragCrossWidth != iconDragCrossWidth && iconDragCrossWidth >= 0) {
            this._iconDragCrossWidth = iconDragCrossWidth;
            this.smartRerender();
        }
    }

    private int[] getIconDragCrossSize() {
        int[] nArray;
        if (this.getIconDragCrossWidth() < 0 || this.getIconDragCrossHeight() < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconDragCrossWidth();
            nArray = nArray2;
            nArray2[1] = this.getIconDragCrossHeight();
        }
        return nArray;
    }

    public String getIconImage() {
        return this._iconImage;
    }

    public void setIconImage(String iconImage) {
        if (iconImage != null && !iconImage.equals(this._iconImage)) {
            this._iconImage = iconImage;
            this.smartUpdate("iconImage", this.encodeURL(iconImage));
        }
    }

    public String getIconImageMap() {
        return this._iconImageMap;
    }

    public void setIconImageMap(String iconImageMap) {
        if (iconImageMap != null && !iconImageMap.equals(this._iconImageMap)) {
            this._iconImageMap = iconImageMap;
            this.smartRerender();
        }
    }

    public int getIconInfoAnchorX() {
        return this._iconInfoAnchorX;
    }

    public void setIconInfoAnchorX(int iconInfoAnchorX) {
        if (this._iconInfoAnchorX != iconInfoAnchorX && iconInfoAnchorX > -100) {
            this._iconInfoAnchorX = iconInfoAnchorX;
            this.smartRerender();
        }
    }

    public int getIconInfoAnchorY() {
        return this._iconInfoAnchorY;
    }

    public void setIconInfoAnchorY(int iconInfoAnchorY) {
        if (this._iconInfoAnchorY != iconInfoAnchorY && iconInfoAnchorY > -100) {
            this._iconInfoAnchorY = iconInfoAnchorY;
            this.smartRerender();
        }
    }

    private int[] getIconInfoAnchor() {
        int[] nArray;
        if (this.getIconInfoAnchorX() < 0 || this.getIconInfoAnchorY() < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconInfoAnchorX();
            nArray = nArray2;
            nArray2[1] = this.getIconInfoAnchorY();
        }
        return nArray;
    }

    public int getIconMaxHeight() {
        return this._iconMaxHeight;
    }

    public void setIconMaxHeight(int iconMaxHeight) {
        if (this._iconMaxHeight != iconMaxHeight && iconMaxHeight >= 0) {
            this._iconMaxHeight = iconMaxHeight;
            this.smartRerender();
        }
    }

    public String getIconMozPrintImage() {
        return this._iconMozPrintImage;
    }

    public void setIconMozPrintImage(String iconMozPrintImage) {
        if (iconMozPrintImage != null && !iconMozPrintImage.equals(this._iconMozPrintImage)) {
            this._iconMozPrintImage = iconMozPrintImage;
            this.smartRerender();
        }
    }

    public String getIconPrintImage() {
        return this._iconPrintImage;
    }

    public void setIconPrintImage(String iconPrintImage) {
        if (iconPrintImage != null && !iconPrintImage.equals(this._iconPrintImage)) {
            this._iconPrintImage = iconPrintImage;
            this.smartRerender();
        }
    }

    public String getIconPrintShadow() {
        return this._iconPrintShadow;
    }

    public void setIconPrintShadow(String iconPrintShadow) {
        if (iconPrintShadow != null && !iconPrintShadow.equals(this._iconPrintShadow)) {
            this._iconPrintShadow = iconPrintShadow;
            this.smartRerender();
        }
    }

    public String getIconShadow() {
        return this._iconShadow;
    }

    public void setIconShadow(String iconShadow) {
        if (iconShadow != null && !iconShadow.equals(this._iconShadow)) {
            this._iconShadow = iconShadow;
            this.smartRerender();
        }
    }

    public int getIconShadowHeight() {
        return this._iconShadowHeight;
    }

    public void setIconShadowHeight(int iconShadowHeight) {
        if (this._iconShadowHeight != iconShadowHeight && iconShadowHeight >= 0) {
            this._iconShadowHeight = iconShadowHeight;
            this.smartRerender();
        }
    }

    public int getIconShadowWidth() {
        return this._iconShadowWidth;
    }

    public void setIconShadowWidth(int iconShadowWidth) {
        if (this._iconShadowWidth != iconShadowWidth && iconShadowWidth >= 0) {
            this._iconShadowWidth = iconShadowWidth;
            this.smartRerender();
        }
    }

    private int[] getIconShadowSize() {
        int[] nArray;
        if (this.getIconShadowWidth() < 0 || this.getIconShadowHeight() < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconShadowWidth();
            nArray = nArray2;
            nArray2[1] = this.getIconShadowHeight();
        }
        return nArray;
    }

    public int getIconHeight() {
        return this._iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        if (this._iconHeight != iconHeight && iconHeight >= 0) {
            this._iconHeight = iconHeight;
            this.smartRerender();
        }
    }

    public void setIconSizeHeight(int iconHeight) {
        this.setIconHeight(iconHeight);
    }

    public int getIconWidth() {
        return this._iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        if (this._iconWidth != iconWidth && iconWidth >= 0) {
            this._iconWidth = iconWidth;
            this.smartRerender();
        }
    }

    private int[] getIconSize() {
        int[] nArray;
        if (this.getIconWidth() < 0 || this.getIconHeight() < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.getIconWidth();
            nArray = nArray2;
            nArray2[1] = this.getIconHeight();
        }
        return nArray;
    }

    public String getIconTransparent() {
        return this._iconTransparent;
    }

    public void setIconTransparent(String iconTransparent) {
        if (iconTransparent != null && !iconTransparent.equals(this._iconTransparent)) {
            this._iconTransparent = iconTransparent;
            this.smartRerender();
        }
    }

    public int getMaxzoom() {
        return this._maxzoom;
    }

    public void setMaxzoom(int lv) {
        if (this._maxzoom != lv) {
            this._maxzoom = lv;
            this.smartRerender();
        }
    }

    public int getMinzoom() {
        return this._minzoom;
    }

    public void setMinzoom(int lv) {
        if (lv < 0) {
            throw new UiException("minzoom level must be larger then 0. minzoom: " + lv);
        }
        if (this._minzoom != lv) {
            this._minzoom = lv;
            this.smartRerender();
        }
    }

    private String encodeURL(String url) {
        Desktop desktop = this.getDesktop();
        return (desktop == null ? Executions.getCurrent() : desktop.getExecution()).encodeURL(url);
    }

    boolean isGinfo() {
        return false;
    }

    protected void setAnchorByClient(LatLng anchor) {
        this._anchor = anchor;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.getIconImage() != null) {
            this.render(renderer, "iconImage", this.encodeURL(this.getIconImage()));
        }
        if (this.getIconShadow() != null) {
            this.render(renderer, "iconShadow", this.encodeURL(this.getIconShadow()));
        }
        if (this.getIconSize() != null) {
            this.render(renderer, "iconSize", this.getIconSize());
        }
        if (this.getIconShadowSize() != null) {
            this.render(renderer, "iconShadowSize", this.getIconShadowSize());
        }
        if (this.getIconAnchor() != null) {
            this.render(renderer, "iconAnchor", this.getIconAnchor());
        }
        if (this.getIconInfoAnchor() != null) {
            this.render(renderer, "iconInfoAnchor", this.getIconInfoAnchor());
        }
        if (this.getIconPrintImage() != null) {
            this.render(renderer, "iconPrintImage", this.encodeURL(this.getIconPrintImage()));
        }
        if (this.getIconMozPrintImage() != null) {
            this.render(renderer, "iconMozPrintImage", this.encodeURL(this.getIconMozPrintImage()));
        }
        if (this.getIconPrintShadow() != null) {
            this.render(renderer, "iconPrintShadow", this.encodeURL(this.getIconPrintShadow()));
        }
        if (this.getIconTransparent() != null) {
            this.render(renderer, "iconTransparent", this.encodeURL(this.getIconTransparent()));
        }
        if (this.getIconImageMap() != null) {
            this.render(renderer, "iconImageMap", this.getIconImageMap());
        }
        if (this.getIconMaxHeight() >= 0) {
            this.render(renderer, "iconMaxHeight", new Integer(this.getIconMaxHeight()));
        }
        if (this.getIconDragCrossImage() != null) {
            this.render(renderer, "iconDragCrossImage", this.encodeURL(this.getIconDragCrossImage()));
        }
        if (this.getIconDragCrossSize() != null) {
            this.render(renderer, "iconDragCrossSize", this.getIconDragCrossSize());
        }
        if (this.getIconDragCrossAnchor() != null) {
            this.render(renderer, "iconDragCrossAnchor", this.getIconDragCrossAnchor());
        }
        if (this.isDraggingEnabled()) {
            this.render(renderer, "draggingEnabled", true);
        }
        if (this.getTooltiptext() != null) {
            this.render(renderer, "tooltiptext", this.getTooltiptext());
        }
        this.render(renderer, "maxzoom", new Integer(this.getMaxzoom()));
        this.render(renderer, "minzoom", new Integer(this.getMinzoom()));
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onMapDrop")) {
            MapDropEvent evt = MapDropEvent.getMapDropEvent(request);
            this.setAnchorByClient(evt.getLatLng());
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    private void smartRerender() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (this.getIconShadow() != null) {
            info.put("iconShadow", this.encodeURL(this.getIconShadow()));
        }
        if (this.getIconSize() != null) {
            info.put("iconSize", this.getIconSize());
        }
        if (this.getIconShadowSize() != null) {
            info.put("iconShadowSize", this.getIconShadowSize());
        }
        if (this.getIconAnchor() != null) {
            info.put("iconAnchor", this.getIconAnchor());
        }
        if (this.getIconInfoAnchor() != null) {
            info.put("iconInfoAnchor", this.getIconInfoAnchor());
        }
        if (this.getIconPrintImage() != null) {
            info.put("iconPrintImage", this.encodeURL(this.getIconPrintImage()));
        }
        if (this.getIconMozPrintImage() != null) {
            info.put("iconMozPrintImage", this.encodeURL(this.getIconMozPrintImage()));
        }
        if (this.getIconPrintShadow() != null) {
            info.put("iconPrintShadow", this.encodeURL(this.getIconPrintShadow()));
        }
        if (this.getIconTransparent() != null) {
            info.put("iconTransparent", this.encodeURL(this.getIconTransparent()));
        }
        if (this.getIconImageMap() != null) {
            info.put("iconImageMap", this.getIconImageMap());
        }
        if (this.getIconMaxHeight() >= 0) {
            info.put("iconMaxHeight", new Integer(this.getIconMaxHeight()));
        }
        if (this.getIconDragCrossImage() != null) {
            info.put("iconDragCrossImage", this.encodeURL(this.getIconDragCrossImage()));
        }
        if (this.getIconDragCrossSize() != null) {
            info.put("iconDragCrossSize", this.getIconDragCrossSize());
        }
        if (this.getIconDragCrossAnchor() != null) {
            info.put("iconDragCrossAnchor", this.getIconDragCrossAnchor());
        }
        if (this.getTooltiptext() != null) {
            info.put("tooltiptext", this.getTooltiptext());
        }
        info.put("maxzoom", new Integer(this.getMaxzoom()));
        info.put("minzoom", new Integer(this.getMinzoom()));
        this.smartUpdate("rerender_", info);
    }

    static {
        Gmarker.addClientEvent((Class)Gmarker.class, (String)"onMapDrop", (int)8193);
    }
}

