/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jpedal.PdfDecoder;
import org.jpedal.PdfPanel;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfAnnots;
import org.jpedal.objects.PdfFormData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ActionHandler;
import org.jpedal.objects.acroforms.AnnotStream;
import org.jpedal.objects.acroforms.DefaultActionHandler;
import org.jpedal.objects.acroforms.DefaultFormFactory;
import org.jpedal.objects.acroforms.FixImageIcon;
import org.jpedal.objects.acroforms.FormDecoder;
import org.jpedal.objects.acroforms.FormFactory;
import org.jpedal.objects.acroforms.FormObject;
import org.jpedal.objects.acroforms.FormStream;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class DefaultAcroRenderer
implements AcroRenderer {
    public static final boolean useXFACode = true;
    private final boolean showMethods = false;
    private static final boolean debug = false;
    private static final boolean debugUnimplemented = false;
    int[] xReached;
    int[] yReached;
    FormFactory formFactory;
    public static final int ANNOTATION = 1;
    public static final int FORM = 2;
    public static final int XFAFORM = 3;
    public int type = 0;
    private Map nameToCompIndex;
    private String[] defaultValues;
    private Map typeValues;
    private Component[] allFields;
    private PdfPageData pageData;
    private int insetW;
    private int insetH;
    private float lastScaling = -1.0f;
    private int oldRotation = 0;
    private int oldIndent = 0;
    private List acroFormDataList;
    private int formCount = 0;
    private int fieldCount = 0;
    private int nextFreeField = 0;
    private float[][] boundingBoxs;
    private int[] fontSize;
    private int[] pageMap;
    private int[] trackPagesRendered;
    private int currentPage;
    private int startID;
    private int pageHeight;
    private int cropOtherY;
    private PdfDecoder panel;
    protected int pageCount = 0;
    private float displayScaling;
    private PdfObjectReader currentPdfFile;
    private FormDecoder formDecoder;
    private int[] fontSizes;
    private String lastNameAdded = "";
    private Map additionFieldsMap = new HashMap();
    private float scaling = 0.0f;
    private int rotation;
    private int startPage;
    private int endPage;
    private int indent;
    ActionHandler formsActionHandler;
    private Map duplicates = new HashMap();

    public DefaultAcroRenderer() {
        this(null);
    }

    public DefaultAcroRenderer(Object object) {
        this.resetActionHandler(object);
    }

    public void resetActionHandler(Object object) {
        this.formsActionHandler = object != null ? (ActionHandler)object : new DefaultActionHandler();
        if (this.formFactory != null) {
            this.formFactory.reset(this, this.formsActionHandler);
        }
    }

    public void removeDisplayComponentsFromScreen(PdfPanel pdfPanel) {
        pdfPanel.removeAll();
    }

    public void init(Object object, int n, int n2, PdfPageData pdfPageData, PdfObjectReader pdfObjectReader) {
        boolean bl = true;
        this.currentPdfFile = pdfObjectReader;
        this.insetW = n;
        this.insetH = n2;
        this.pageData = pdfPageData;
        if (object == null) {
            this.acroFormDataList = null;
            this.formCount = 0;
            this.fieldCount = 0;
        } else if (this.type == 2) {
            PdfFormData pdfFormData = (PdfFormData)object;
            if (!pdfFormData.hasXFAFormData()) {
                this.formDecoder = new FormStream(pdfObjectReader);
            }
            this.acroFormDataList = pdfFormData.getFormData();
            this.formCount = pdfFormData.getTotalCount();
            this.fieldCount = this.acroFormDataList.size();
        } else if (this.type == 1) {
            PdfAnnots pdfAnnots = (PdfAnnots)object;
            this.formDecoder = new AnnotStream(pdfObjectReader);
            this.acroFormDataList = pdfAnnots.getAnnotRawDataList();
            int n3 = this.acroFormDataList.size();
            this.formCount += n3;
            this.fieldCount = n3;
            bl = false;
        }
        this.resetContainers(bl);
    }

    protected void resetContainers(boolean bl) {
        this.additionFieldsMap.clear();
        this.nextFreeField = 0;
        if (bl) {
            this.allFields = new Component[this.formCount + 1];
            this.pageMap = new int[this.formCount + 1];
            this.fontSize = new int[this.formCount + 1];
            this.nameToCompIndex = new HashMap(this.formCount + 1);
            this.defaultValues = new String[this.formCount + 1];
            this.typeValues = new HashMap();
            this.boundingBoxs = new float[this.formCount + 1][4];
            this.fontSizes = new int[this.formCount + 1];
            this.trackPagesRendered = new int[this.pageCount + 1];
            for (int i = 0; i < this.pageCount + 1; ++i) {
                this.trackPagesRendered[i] = -1;
            }
        } else {
            Component[] componentArray = this.allFields;
            int[] nArray = this.pageMap;
            int[] nArray2 = this.fontSize;
            String[] stringArray = this.defaultValues;
            float[][] fArray = this.boundingBoxs;
            int[] nArray3 = this.fontSizes;
            this.allFields = new Component[this.formCount + 1];
            this.pageMap = new int[this.formCount + 1];
            this.fontSize = new int[this.formCount + 1];
            this.defaultValues = new String[this.formCount + 1];
            this.boundingBoxs = new float[this.formCount + 1][4];
            this.fontSizes = new int[this.formCount + 1];
            for (int i = 0; i < componentArray.length && componentArray[i] != null; ++i) {
                this.allFields[i] = componentArray[i];
                this.pageMap[i] = nArray[i];
                this.fontSize[i] = nArray2[i];
                this.defaultValues[i] = stringArray[i];
                System.arraycopy(fArray[i], 0, this.boundingBoxs[i], 0, 4);
                this.fontSizes[i] = nArray3[i];
                ++this.nextFreeField;
            }
        }
        if (this.formFactory == null) {
            this.formFactory = new DefaultFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
        }
    }

    public void createDisplayComponentsForPage(int n, PdfDecoder pdfDecoder, float f, int n2) {
        this.scaling = f;
        this.rotation = n2;
        int n3 = this.pageData.getMediaBoxHeight(n);
        int n4 = this.pageData.getCropBoxHeight(n) + this.pageData.getCropBoxY(n);
        this.cropOtherY = 0;
        if (n3 != n4) {
            this.cropOtherY = n3 - n4;
        }
        this.pageHeight = n3;
        this.displayScaling = f;
        this.currentPage = n;
        if (pdfDecoder != null) {
            this.panel = pdfDecoder;
        }
        if (this.type == 1) {
            ((AnnotStream)this.formDecoder).setPageHeightAndInset(this.pageHeight, this.insetH);
        }
        if (this.trackPagesRendered == null) {
            return;
        }
        int n5 = this.trackPagesRendered[n];
        if (n5 == -1) {
            Object object;
            this.startID = this.nextFreeField;
            this.trackPagesRendered[n] = this.nextFreeField;
            if (this.type == 2) {
                this.formDecoder.resetItems();
            }
            FormObject[] formObjectArray = null;
            int n6 = 0;
            if (this.type == 3) {
                formObjectArray = new FormObject[this.fieldCount];
            }
            for (int i = this.fieldCount - 1; i > -1; --i) {
                Component component;
                object = (Map)this.acroFormDataList.get(i);
                int n7 = -1;
                Object object2 = this.currentPdfFile.resolveToMapOrString("PageNumber", object.get("PageNumber"));
                if (object2 != null) {
                    n7 = Integer.parseInt((String)object2);
                }
                if (n7 == -1 && this.type == 1) {
                    n7 = n;
                }
                if (n7 != n) continue;
                ButtonGroup buttonGroup = new ButtonGroup();
                FormObject formObject = null;
                if (this.type == 3) {
                    component = null;
                    formObject = ((AnnotStream)this.formDecoder).createAppearanceString((Map)object, this.currentPdfFile);
                    if (formObject == null) continue;
                    formObjectArray[n6++] = formObject;
                } else {
                    formObject = this.formDecoder.createAppearanceString((Map)object, this.currentPdfFile);
                    if (formObject == null) continue;
                    component = this.createField(formObject, buttonGroup, this.nextFreeField);
                }
                this.checkButtonGroupAndApply(n, f, n2, n7, buttonGroup, component, formObject);
            }
            if (this.additionFieldsMap.get("" + n) != null) {
                ArrayList arrayList = (ArrayList)this.additionFieldsMap.get("" + n);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    this.apply((Component)object.next(), n, f, n2);
                }
            }
        }
    }

    private void checkButtonGroupAndApply(int n, float f, int n2, int n3, ButtonGroup buttonGroup, Component component, FormObject formObject) {
        if (buttonGroup.getButtonCount() > 1) {
            AbstractButton[] abstractButtonArray = this.sortGroupSmallestFirst(buttonGroup);
            for (int i = 0; i < buttonGroup.getButtonCount(); ++i) {
                ArrayList arrayList;
                if (abstractButtonArray[i].getLabel().equals("" + n)) {
                    if (formObject.currentState != null && formObject.currentState.equals(this.removeStateToCheck(abstractButtonArray[i].getName(), true)) || formObject.onState != null && formObject.onState.equals(this.removeStateToCheck(abstractButtonArray[i].getName(), true))) {
                        abstractButtonArray[i].setSelected(true);
                    }
                    this.apply(abstractButtonArray[i], n3, f, n2);
                    continue;
                }
                if (this.additionFieldsMap.get(abstractButtonArray[i].getLabel()) != null) {
                    arrayList = (ArrayList)this.additionFieldsMap.get(abstractButtonArray[i].getLabel());
                    arrayList.add(abstractButtonArray[i]);
                    this.additionFieldsMap.put(abstractButtonArray[i].getLabel(), arrayList);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(abstractButtonArray[i]);
                this.additionFieldsMap.put(abstractButtonArray[i].getLabel(), arrayList);
            }
        } else if (component != null) {
            if (formObject.flags[14] && component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setBounds(formObject.Rect);
                abstractButton.setText("" + formObject.pageNumber);
                new ButtonGroup().add(abstractButton);
            }
            this.apply(component, n3, f, n2);
        }
    }

    public void displayComponentsOnscreen(int n, int n2, PdfPanel pdfPanel, float f, int n3) {
        this.startPage = n;
        this.endPage = n2++;
        for (int i = n; i < n2; ++i) {
            this.startID = this.trackPagesRendered.length > i ? this.trackPagesRendered[i] : -1;
            int n4 = this.startID;
            if (this.startID == -1) continue;
            while (this.pageMap[n4] >= n && this.pageMap[n4] < n2) {
                if (this.allFields[n4] != null) {
                    this.scaleComponent(this.pageMap[n4], f, n3, n4, this.allFields[n4], true);
                    if (pdfPanel != null) {
                        pdfPanel.add(this.allFields[n4]);
                    }
                }
                if (++n4 != this.pageMap.length) continue;
            }
        }
    }

    public void removePageRangeFromDisplay(int n, int n2, PdfPanel pdfPanel) {
        try {
            for (int i = n; i < n2; ++i) {
                int n3 = this.trackPagesRendered[i];
                if (n3 == -1) continue;
                while (this.pageMap[n3] >= n && this.pageMap[n3] <= n2) {
                    if (this.allFields[n3] != null) {
                        pdfPanel.remove(this.allFields[n3]);
                    }
                    if (++n3 != this.pageMap.length) continue;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private AbstractButton[] sortGroupSmallestFirst(ButtonGroup buttonGroup) {
        int n = buttonGroup.getButtonCount();
        Component[] componentArray = new AbstractButton[n];
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        for (int i = 0; i < n; ++i) {
            if (!enumeration.hasMoreElements()) continue;
            componentArray[i] = enumeration.nextElement();
        }
        return (AbstractButton[])DefaultAcroRenderer.sortCompsAscending(componentArray);
    }

    public static final Component[] sortCompsAscending(Component[] componentArray) {
        int n = componentArray.length;
        int n2 = n / 2;
        int n3 = n - 1;
        while (n2 > 0) {
            DefaultAcroRenderer.siftCompsAscending(componentArray, --n2, n3);
        }
        while (n3 > 0) {
            Component component = componentArray[0];
            componentArray[0] = componentArray[n3];
            componentArray[n3] = component;
            DefaultAcroRenderer.siftCompsAscending(componentArray, n2, --n3);
        }
        return componentArray;
    }

    private static void siftCompsAscending(Component[] componentArray, int n, int n2) {
        int n3 = n;
        Component component = componentArray[n3];
        int n4 = 2 * n + 1;
        if (n4 < n2 && DefaultAcroRenderer.shouldSwapControl(componentArray[n4], componentArray[n4 + 1])) {
            ++n4;
        }
        while (n4 <= n2 && DefaultAcroRenderer.shouldSwapControl(component, componentArray[n4])) {
            componentArray[n3] = componentArray[n4];
            n3 = n4;
            if ((n4 = 2 * n4 + 1) >= n2 || !DefaultAcroRenderer.shouldSwapControl(componentArray[n4], componentArray[n4 + 1])) continue;
            ++n4;
        }
        componentArray[n3] = component;
    }

    private static boolean shouldSwapControl(Component component, Component component2) {
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = component2.getBounds();
        return rectangle.width * rectangle.height < rectangle2.width * rectangle2.height;
    }

    private String removeStateToCheck(String string, boolean bl) {
        int n;
        if (string != null && (n = string.indexOf("-(")) != -1) {
            string = bl ? string.substring(n + 2, string.length() - 1) : string.substring(0, n);
        }
        return string;
    }

    private void apply(Component component, int n, float f, int n2) {
        int n3;
        String string = this.removeStateToCheck(component.getName(), false);
        if (string != null && !this.lastNameAdded.equals(string)) {
            this.nameToCompIndex.put(string, new Integer(this.nextFreeField));
            this.lastNameAdded = string;
        }
        int n4 = -1;
        n4 = n3 = this.fontSizes[this.nextFreeField];
        if (component != null) {
            Rectangle rectangle = component.getBounds();
            if (rectangle != null) {
                float f2 = rectangle.x;
                float f3 = rectangle.y;
                float f4 = rectangle.width + rectangle.x;
                float f5 = rectangle.height + rectangle.y;
                this.boundingBoxs[this.nextFreeField][0] = f2;
                this.boundingBoxs[this.nextFreeField][1] = f3;
                this.boundingBoxs[this.nextFreeField][2] = f4;
                this.boundingBoxs[this.nextFreeField][3] = f5;
            }
            this.allFields[this.nextFreeField] = component;
            this.fontSize[this.nextFreeField] = n4;
            this.scaleComponent(n, f, n2, this.nextFreeField, component, true);
        }
        this.pageMap[this.nextFreeField] = n;
        ++this.nextFreeField;
    }

    private Component createField(FormObject formObject, ButtonGroup buttonGroup, int n) {
        Component component = null;
        try {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n2 = formObject.type;
            if (n2 != -1) {
                bl2 = n2 == 0;
                bl3 = n2 == 2;
                bl4 = n2 == 1;
                bl5 = n2 == 3;
            }
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean[] blArray = formObject.flags;
            if (blArray != null) {
                bl6 = blArray[1];
                bl7 = blArray[2];
                bl8 = blArray[3];
            }
            if (bl2) {
                bl = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                if (blArray != null) {
                    bl = blArray[16];
                    bl9 = blArray[15];
                    bl10 = blArray[14];
                    bl11 = blArray[25];
                }
                if (bl) {
                    this.typeValues.put(formObject.fieldName, FormFactory.PUSHBUTTON);
                    component = this.formFactory.pushBut(formObject);
                } else if (bl9) {
                    this.typeValues.put(formObject.fieldName, FormFactory.RADIOBUTTON);
                    if (formObject.kidData != null) {
                        Iterator iterator = formObject.kidData.keySet().iterator();
                        while (iterator.hasNext()) {
                            FormObject formObject2 = (FormObject)formObject.kidData.get(iterator.next());
                            Component component2 = this.createField(formObject2, buttonGroup, ++n);
                            try {
                                AbstractButton abstractButton = (AbstractButton)component2;
                                abstractButton.setBounds(formObject2.Rect);
                                abstractButton.setLabel("" + formObject2.pageNumber);
                                buttonGroup.add(abstractButton);
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    component = this.formFactory.radioBut(formObject);
                } else {
                    this.typeValues.put(formObject.fieldName, FormFactory.CHECKBOXBUTTON);
                    if (formObject.kidData != null) {
                        Iterator iterator = formObject.kidData.keySet().iterator();
                        while (iterator.hasNext()) {
                            FormObject formObject3 = (FormObject)formObject.kidData.get(iterator.next());
                            Component component3 = this.createField(formObject3, buttonGroup, ++n);
                            try {
                                AbstractButton abstractButton = (AbstractButton)component3;
                                abstractButton.setBounds(formObject3.Rect);
                                abstractButton.setLabel("" + formObject3.pageNumber);
                                buttonGroup.add(abstractButton);
                            }
                            catch (ClassCastException classCastException) {}
                        }
                    }
                    component = this.formFactory.checkBoxBut(formObject);
                }
            } else if (bl3) {
                bl = false;
                boolean bl12 = false;
                boolean bl13 = false;
                boolean bl14 = false;
                boolean bl15 = false;
                boolean bl16 = false;
                if (blArray != null) {
                    bl = blArray[12];
                    bl12 = blArray[13];
                    bl13 = blArray[23];
                    bl14 = blArray[25];
                    bl15 = blArray[20];
                    bl16 = blArray[22];
                }
                if (bl) {
                    if (bl12) {
                        this.typeValues.put(formObject.fieldName, FormFactory.MULTILINEPASSWORD);
                        component = this.formFactory.multiLinePassword(formObject);
                    } else {
                        this.typeValues.put(formObject.fieldName, FormFactory.MULTILINETEXT);
                        component = this.formFactory.multiLineText(formObject);
                    }
                } else if (bl12) {
                    this.typeValues.put(formObject.fieldName, FormFactory.SINGLELINEPASSWORD);
                    component = this.formFactory.singleLinePassword(formObject);
                } else {
                    this.typeValues.put(formObject.fieldName, FormFactory.SINGLELINETEXT);
                    component = this.formFactory.singleLineText(formObject);
                }
            } else if (bl4) {
                bl = false;
                boolean bl17 = false;
                boolean bl18 = false;
                boolean bl19 = false;
                boolean bl20 = false;
                boolean bl21 = false;
                if (blArray != null) {
                    bl = blArray[17];
                    bl17 = blArray[21];
                    bl18 = blArray[19];
                    bl19 = blArray[18];
                    bl20 = blArray[22];
                    bl21 = blArray[26];
                }
                if (bl) {
                    this.typeValues.put(formObject.fieldName, FormFactory.COMBOBOX);
                    component = this.formFactory.comboBox(formObject);
                } else {
                    this.typeValues.put(formObject.fieldName, FormFactory.LIST);
                    component = this.formFactory.listField(formObject);
                }
            } else if (bl5) {
                this.typeValues.put(formObject.fieldName, FormFactory.SIGNATURE);
                component = this.formFactory.signature(formObject);
            } else if (this.type == 1) {
                this.typeValues.put(formObject.fieldName, FormFactory.ANNOTATION);
                component = this.formFactory.annotationButton(formObject);
            } else {
                return null;
            }
            if (formObject.fieldName != null) {
                String string = formObject.fieldName;
                if (formObject.stateTocheck != null) {
                    string = string + "-(" + formObject.stateTocheck + ")";
                }
                component.setName(string);
            }
            if (formObject.Rect != null) {
                Rectangle rectangle = formObject.Rect;
                component.setBounds(rectangle);
            }
            this.fontSizes[n] = formObject.textSize;
            this.defaultValues[n] = formObject.valuesMap != null ? (String)formObject.valuesMap.get(Strip.checkRemoveLeadingSlach(formObject.defaultValue)) : Strip.checkRemoveLeadingSlach(formObject.defaultValue);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return component;
    }

    public Component[] getDisplayComponentsForPage(int n) {
        return this.allFields;
    }

    public void resetScaledLocation(float f, int n, int n2) {
        this.indent = n2;
        this.displayScaling = f;
        this.rotation = n;
        if (this.trackPagesRendered == null) {
            return;
        }
        if (f != this.lastScaling || n != this.oldRotation || n2 != this.oldIndent) {
            this.oldRotation = n;
            this.lastScaling = f;
            this.oldIndent = n2;
            int n3 = this.startPage < this.trackPagesRendered.length - 1 ? this.trackPagesRendered[this.startPage] : 0;
            if (this.allFields != null && this.currentPage > 0 && n3 != -1 && this.pageMap.length > n3) {
                while (this.pageMap[n3] >= this.startPage && this.pageMap[n3] <= this.endPage && this.allFields[n3] != null) {
                    if (this.panel != null) {
                        this.panel.remove(this.allFields[n3]);
                    }
                    this.scaleComponent(this.pageMap[n3], f, n, n3, this.allFields[n3], true);
                    if (this.panel != null) {
                        this.panel.add(this.allFields[n3]);
                    }
                    ++n3;
                }
            }
        }
    }

    private void scaleComponent(int n, float f, int n2, int n3, Component component, boolean bl) {
        if (component == null) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.pageData.getMediaBoxWidth(n) - this.pageData.getCropBoxWidth(n) - this.pageData.getCropBoxX(n);
        if (n2 == 0) {
            int n9 = this.pageData.getCropBoxX(n);
            float f2 = this.boundingBoxs[n3][0] - (float)n9 + (float)this.insetW;
            if (!bl) {
                f2 += (float)n9;
            }
            float f3 = (float)this.pageData.getMediaBoxHeight(n) - this.boundingBoxs[n3][3] - (float)this.cropOtherY + (float)this.insetH;
            float f4 = this.boundingBoxs[n3][2] - this.boundingBoxs[n3][0];
            float f5 = this.boundingBoxs[n3][3] - this.boundingBoxs[n3][1];
            n4 = (int)((f2 - (float)this.insetW) * f + (float)this.insetW);
            n5 = (int)((f3 - (float)this.insetH) * f + (float)this.insetH);
            n6 = (int)(f4 * f);
            n7 = (int)(f5 * f);
        } else if (n2 == 90) {
            float f6 = this.boundingBoxs[n3][1] - (float)this.pageData.getCropBoxY(n) + (float)this.insetW;
            float f7 = this.boundingBoxs[n3][0] - (float)this.pageData.getCropBoxX(n) + (float)this.insetH;
            float f8 = this.boundingBoxs[n3][3] - this.boundingBoxs[n3][1];
            float f9 = this.boundingBoxs[n3][2] - this.boundingBoxs[n3][0];
            n4 = (int)((f6 - (float)this.insetH) * f + (float)this.insetH);
            n5 = (int)((f7 - (float)this.insetW) * f + (float)this.insetW);
            n6 = (int)(f8 * f);
            n7 = (int)(f9 * f);
        } else if (n2 == 180) {
            int n10 = (int)((float)this.pageData.getMediaBoxWidth(n) - this.boundingBoxs[n3][2] - (float)n8) + this.insetW;
            int n11 = (int)(this.boundingBoxs[n3][1] - (float)this.pageData.getCropBoxY(n)) + this.insetH;
            int n12 = (int)(this.boundingBoxs[n3][2] - this.boundingBoxs[n3][0]);
            int n13 = (int)(this.boundingBoxs[n3][3] - this.boundingBoxs[n3][1]);
            n4 = (int)((float)(n10 - this.insetW) * f + (float)this.insetW);
            n5 = (int)((float)(n11 - this.insetH) * f + (float)this.insetH);
            n6 = (int)((float)n12 * f);
            n7 = (int)((float)n13 * f);
        } else if (n2 == 270) {
            float f10 = (float)this.pageData.getMediaBoxHeight(n) - this.boundingBoxs[n3][3] - (float)this.cropOtherY + (float)this.insetW;
            float f11 = (float)this.pageData.getMediaBoxWidth(n) - this.boundingBoxs[n3][2] - (float)n8 + (float)this.insetH;
            float f12 = this.boundingBoxs[n3][3] - this.boundingBoxs[n3][1];
            float f13 = this.boundingBoxs[n3][2] - this.boundingBoxs[n3][0];
            n4 = (int)((f10 - (float)this.insetH) * f + (float)this.insetH);
            n5 = (int)((f11 - (float)this.insetW) * f + (float)this.insetW);
            n6 = (int)(f12 * f);
            n7 = (int)(f13 * f);
        }
        if (this.xReached != null) {
            n4 += this.xReached[n];
            n5 += this.yReached[n];
        }
        component.setBounds(this.indent + n4, n5, n6, n7);
        Font font = component.getFont();
        if (font != null) {
            int n14;
            int n15 = this.fontSize[n3];
            if (n15 == -1) {
                n15 = 8;
            }
            if (n15 == 0) {
                String string;
                int n16 = (int)(this.boundingBoxs[n3][3] - this.boundingBoxs[n3][1]);
                int n17 = (int)(this.boundingBoxs[n3][2] - this.boundingBoxs[n3][0]);
                n15 = n16 = (int)((double)n16 * 0.85);
                if (component instanceof JTextComponent) {
                    if (((JTextComponent)component).getText().length() * n16 / 2 > n17) {
                        int n18 = ((JTextComponent)component).getText().length();
                        n15 = n17 /= n18;
                    }
                } else if (component instanceof JButton && (string = ((JButton)component).getText()) != null && ((JButton)component).getText().length() * n16 / 2 > n17) {
                    int n19 = ((JButton)component).getText().length();
                    if (n19 > 0) {
                        n17 /= n19;
                    }
                    n15 = n17;
                }
            }
            if ((n14 = (int)((float)n15 * f)) < 1) {
                n14 = 1;
            }
            Font font2 = new Font(font.getFontName(), font.getStyle(), n14);
            component.setFont(font2);
        }
        if (component != null && component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Icon icon = abstractButton.getIcon();
            if (icon instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getRolloverIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
            if ((icon = abstractButton.getRolloverSelectedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)icon).setWH(component.getWidth(), component.getHeight());
            }
        }
        if (bl) {
            // empty if block
        }
    }

    public void renderFormsOntoG2(Graphics2D graphics2D, int n, float f, int n2) {
        AffineTransform affineTransform;
        block7: {
            affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = graphics2D.getTransform();
            affineTransform2.scale(1.0, -1.0);
            affineTransform2.translate(0.0, -this.pageHeight - this.insetH);
            graphics2D.setTransform(affineTransform2);
            int n3 = this.trackPagesRendered[n];
            try {
                Component[] componentArray = this.allFields;
                if (componentArray == null || n3 == -1) break block7;
                JPanel jPanel = new JPanel();
                int n4 = this.indent;
                this.indent = 0;
                while (this.pageMap[n3] == n) {
                    Component component = componentArray[n3];
                    if (component != null && component.isVisible()) {
                        jPanel.add(component);
                        try {
                            this.renderComponent(graphics2D, n3, component, n2);
                            jPanel.remove(component);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (++n3 != this.pageMap.length) continue;
                    break;
                }
                this.indent = n4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        graphics2D.setTransform(affineTransform);
        if (this.currentPage == n && this.panel != null) {
            this.resetScaledLocation(this.displayScaling, this.rotation, this.indent);
        }
    }

    private void renderComponent(Graphics2D graphics2D, int n, Component component, int n2) {
        if (component != null) {
            boolean bl = false;
            if (component instanceof JComboBox) {
                if (((JComboBox)component).isEditable()) {
                    bl = true;
                    ((JComboBox)component).setEditable(false);
                }
                if (!UIManager.getLookAndFeel().isNativeLookAndFeel() && ((JComboBox)component).getComponentCount() > 0) {
                    this.renderComponent(graphics2D, n, ((JComboBox)component).getComponent(0), n2);
                }
            }
            this.scaleComponent(this.currentPage, 1.0f, n2, n, component, false);
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(component.getBounds().x - this.insetW, component.getBounds().y + this.cropOtherY);
            component.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
            if (bl) {
                ((JComboBox)component).setEditable(true);
            }
        }
    }

    public Component[] getComponentsByName(String string) {
        if (string == null) {
            return this.allFields;
        }
        Object v = this.nameToCompIndex.get(string);
        if (v == null) {
            return null;
        }
        String string2 = (String)this.duplicates.get(string);
        if (v instanceof Integer) {
            int n = (Integer)v;
            boolean bl = true;
            int n2 = n;
            while (bl) {
                if (n + 1 < this.allFields.length && this.allFields[n + 1] != null && this.removeStateToCheck(this.allFields[n + 1].getName(), false).equals(string)) {
                    ++n;
                    continue;
                }
                bl = false;
            }
            int n3 = n + 1 - n2;
            Component[] componentArray = new Component[n3];
            int n4 = 0;
            while (n4 < n3) {
                componentArray[n4] = this.allFields[n2];
                if (n2 == n) break;
                ++n4;
                ++n2;
            }
            if (string2 != null && string2.indexOf(",") != -1) {
                int n5;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n6 = stringTokenizer.countTokens();
                Component[] componentArray2 = componentArray;
                componentArray = new Component[n3 + n6];
                for (n5 = 0; n5 < n3; ++n5) {
                    componentArray[n5] = componentArray2[n5];
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    componentArray[n5 + n3] = this.allFields[Integer.parseInt(stringTokenizer.nextToken())];
                }
            }
            return componentArray;
        }
        LogWriter.writeFormLog("{stream} ERROR DefaultAcroRenderer.getComponentByName() Object NOT Integer and NOT null", false);
        return null;
    }

    public List getComponentNameList() throws PdfException {
        if (this.trackPagesRendered == null | this.fieldCount == 0) {
            return null;
        }
        for (int i = 1; i < this.pageCount + 1; ++i) {
            this.createDisplayComponentsForPage(i, null, this.scaling, this.rotation);
        }
        List list = this.getComponentNameList(-1);
        return list;
    }

    public List getComponentNameList(int n) throws PdfException {
        if (this.trackPagesRendered == null | this.fieldCount == 0) {
            return null;
        }
        if (n != -1 && this.trackPagesRendered[n] == -1) {
            return null;
        }
        int n2 = n == -1 ? 0 : this.trackPagesRendered[n];
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        String string2 = "";
        while (n == -1 || this.pageMap[n2] == n) {
            if (this.allFields[n2] != null && (string2 = this.removeStateToCheck(this.allFields[n2].getName(), false)) != null && !string.equals(string2)) {
                String string3 = (String)this.duplicates.get(string2);
                if (string3 != null) {
                    this.duplicates.put(string2, string3 + "," + n2);
                } else {
                    this.duplicates.put(string2, "" + n2);
                }
                arrayList.add(string2);
                string = string2;
            }
            if (++n2 != this.pageMap.length) continue;
            break;
        }
        return arrayList;
    }

    public void setFormFactory(FormFactory formFactory) {
        this.formFactory = formFactory;
    }

    public void openFile(int n) {
        this.pageCount = n;
        this.type = 2;
    }

    public List getAllComponents() throws PdfException {
        return null;
    }

    public void setPageDisplacements(int[] nArray, int[] nArray2) {
        this.xReached = nArray;
        this.yReached = nArray2;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public Integer getTypeValueByName(String string) {
        return (Integer)this.typeValues.get(string);
    }
}

