/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.action.AlignWithSupport;

public final class AlignWithResizeStrategyProvider
extends AlignWithSupport
implements ResizeStrategy,
ResizeProvider {
    private boolean outerBounds;

    public AlignWithResizeStrategyProvider(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator, boolean outerBounds) {
        super(collector, interractionLayer, decorator);
        this.outerBounds = outerBounds;
    }

    public Rectangle boundsSuggested(Widget widget, Rectangle originalBounds, Rectangle suggestedBounds, ResizeProvider.ControlPoint controlPoint) {
        Insets insets = widget.getBorder().getInsets();
        int minx = insets.left + insets.right;
        int miny = insets.top + insets.bottom;
        suggestedBounds = widget.convertLocalToScene(suggestedBounds);
        switch (controlPoint) {
            case BOTTOM_CENTER: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width / 2, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, false, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                break;
            }
            case BOTTOM_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                    suggestedLocation.x += insets.left;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                    point.x -= insets.left;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case BOTTOM_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                    suggestedLocation.x -= insets.right;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                    point.x += insets.right;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
                break;
            }
            case CENTER_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y + suggestedBounds.height / 2);
                if (!this.outerBounds) {
                    suggestedLocation.x += insets.left;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, false, false, false);
                if (!this.outerBounds) {
                    point.x -= insets.left;
                }
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case CENTER_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y + suggestedBounds.height / 2);
                if (!this.outerBounds) {
                    suggestedLocation.x -= insets.right;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, false, false, false);
                if (!this.outerBounds) {
                    point.x += insets.right;
                }
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
                break;
            }
            case TOP_CENTER: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width / 2, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, false, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                break;
            }
            case TOP_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                    suggestedLocation.x += insets.left;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                    point.x -= insets.left;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case TOP_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                    suggestedLocation.x -= insets.right;
                }
                Point point = super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                    point.x += insets.right;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
            }
        }
        return widget.convertSceneToLocal(suggestedBounds);
    }

    public void resizingStarted(Widget widget) {
        this.show();
    }

    public void resizingFinished(Widget widget) {
        this.hide();
    }
}

