/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.EnumSet;
import javax.swing.JComponent;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InplaceEditorAction<C extends JComponent>
extends WidgetAction.LockedAdapter
implements InplaceEditorProvider.EditorController {
    private InplaceEditorProvider<C> provider;
    private C editor = null;
    private Widget widget = null;
    private Rectangle rectangle = null;

    public InplaceEditorAction(InplaceEditorProvider<C> provider) {
        this.provider = provider;
    }

    @Override
    protected boolean isLocked() {
        return this.editor != null;
    }

    @Override
    public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getButton() == 1 && event.getClickCount() == 2 && this.openEditor(widget)) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.editor != null) {
            this.closeEditor(true);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.editor != null) {
            this.closeEditor(true);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State keyPressed(Widget widget, WidgetAction.WidgetKeyEvent event) {
        if (event.getKeyChar() == '\n' && this.openEditor(widget)) {
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public final boolean isEditorVisible() {
        return this.editor != null;
    }

    @Override
    public final boolean openEditor(Widget widget) {
        if (this.editor != null) {
            return false;
        }
        Scene scene = widget.getScene();
        JComponent component = scene.getView();
        if (component == null) {
            return false;
        }
        this.editor = this.provider.createEditorComponent(this, widget);
        if (this.editor == null) {
            return false;
        }
        this.widget = widget;
        component.add((Component)this.editor);
        this.provider.notifyOpened(this, widget, this.editor);
        Rectangle rectangle = widget.getScene().convertSceneToView(widget.convertLocalToScene(widget.getBounds()));
        Point center = GeomUtil.center(rectangle);
        Dimension size = ((JComponent)this.editor).getMinimumSize();
        if (rectangle.width > size.width) {
            size.width = rectangle.width;
        }
        if (rectangle.height > size.height) {
            size.height = rectangle.height;
        }
        int x = center.x - size.width / 2;
        int y = center.y - size.height / 2;
        rectangle = new Rectangle(x, y, size.width, size.height);
        this.updateRectangleToFitToView(rectangle);
        Rectangle r = this.provider.getInitialEditorComponentBounds(this, widget, this.editor, rectangle);
        this.rectangle = r != null ? r : rectangle;
        ((Component)this.editor).setBounds(x, y, size.width, size.height);
        this.notifyEditorComponentBoundsChanged();
        ((JComponent)this.editor).requestFocusInWindow();
        return true;
    }

    private void updateRectangleToFitToView(Rectangle rectangle) {
        JComponent component = this.widget.getScene().getView();
        if (rectangle.x + rectangle.width > component.getWidth()) {
            rectangle.x = component.getWidth() - rectangle.width;
        }
        if (rectangle.y + rectangle.height > component.getHeight()) {
            rectangle.y = component.getHeight() - rectangle.height;
        }
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
    }

    @Override
    public final void closeEditor(boolean commit) {
        if (this.editor == null) {
            return;
        }
        Container parent = ((Component)this.editor).getParent();
        Rectangle bounds = parent != null ? ((Component)this.editor).getBounds() : null;
        this.provider.notifyClosing(this, this.widget, this.editor, commit);
        boolean hasFocus = ((Component)this.editor).hasFocus();
        if (bounds != null) {
            parent.remove((Component)this.editor);
            parent.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        this.editor = null;
        this.widget = null;
        this.rectangle = null;
        if (hasFocus && parent != null) {
            parent.requestFocusInWindow();
        }
    }

    @Override
    public void notifyEditorComponentBoundsChanged() {
        EnumSet<InplaceEditorProvider.ExpansionDirection> directions = this.provider.getExpansionDirections(this, this.widget, this.editor);
        if (directions == null) {
            directions = EnumSet.noneOf(InplaceEditorProvider.ExpansionDirection.class);
        }
        Rectangle rectangle = this.rectangle;
        Dimension size = ((JComponent)this.editor).getPreferredSize();
        Dimension minimumSize = ((JComponent)this.editor).getMinimumSize();
        if (minimumSize != null) {
            if (size.width < minimumSize.width) {
                size.width = minimumSize.width;
            }
            if (size.height < minimumSize.height) {
                size.height = minimumSize.height;
            }
        }
        int heightDiff = rectangle.height - size.height;
        int widthDiff = rectangle.width - size.width;
        boolean top = directions.contains((Object)InplaceEditorProvider.ExpansionDirection.TOP);
        boolean bottom = directions.contains((Object)InplaceEditorProvider.ExpansionDirection.BOTTOM);
        if (top) {
            if (bottom) {
                rectangle.y += heightDiff / 2;
                rectangle.height = size.height;
            } else {
                rectangle.y += heightDiff;
                rectangle.height = size.height;
            }
        } else if (bottom) {
            rectangle.height = size.height;
        }
        boolean left = directions.contains((Object)InplaceEditorProvider.ExpansionDirection.LEFT);
        boolean right = directions.contains((Object)InplaceEditorProvider.ExpansionDirection.RIGHT);
        if (left) {
            if (right) {
                rectangle.x += widthDiff / 2;
                rectangle.width = size.width;
            } else {
                rectangle.x += widthDiff;
                rectangle.width = size.width;
            }
        } else if (right) {
            rectangle.width = size.width;
        }
        this.updateRectangleToFitToView(rectangle);
        ((Component)this.editor).setBounds(rectangle);
        ((Component)this.editor).repaint();
    }
}

