/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import org.netbeans.api.visual.anchor.AnchorShape;

public class ArrowAnchorShape
implements AnchorShape {
    private static final Stroke STROKE = new BasicStroke(1.0f, 1, 1);
    private GeneralPath path;
    private int size;

    public ArrowAnchorShape(int degrees, int size) {
        this.size = size;
        this.path = new GeneralPath();
        double radians = Math.PI * (double)degrees / 180.0;
        double cos = Math.cos(radians / 2.0);
        double sin = (double)(-size) * Math.sqrt(1.0 - cos * cos);
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo((float)(cos *= (double)size), (float)(-sin));
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo((float)cos, (float)sin);
    }

    public boolean isLineOriented() {
        return true;
    }

    public int getRadius() {
        return this.size + 1;
    }

    public double getCutDistance() {
        return 0.0;
    }

    public void paint(Graphics2D graphics, boolean source) {
        Stroke previousStroke = graphics.getStroke();
        graphics.setStroke(STROKE);
        graphics.draw(this.path);
        graphics.setStroke(previousStroke);
    }
}

