/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedPlanarGraph {
    private MGraph originalGraph;
    private ArrayList<Face> faces;

    public static EmbeddedPlanarGraph createGraph(MGraph graph) {
        return new EmbeddedPlanarGraph(graph);
    }

    private EmbeddedPlanarGraph(MGraph graph) {
        this.originalGraph = graph;
        this.faces = new ArrayList();
    }

    public MGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public ArrayList<Face> getFaces() {
        return this.faces;
    }

    public void addFace(Face newFace) {
        if (!this.faces.contains(newFace)) {
            this.faces.add(newFace);
        }
    }

    public void addFaces(Collection<Face> newFaces) {
        this.faces.addAll(newFaces);
    }

    public void removeFace(Face faceToRemove) {
        this.faces.remove(faceToRemove);
    }

    public void removeFaces(Collection<Face> facesToRemove) {
        this.faces.removeAll(facesToRemove);
    }

    public Face getOppositeFace(Face face, Face.Dart dart) {
        for (Face f : this.faces) {
            if (f == face || !f.containsEdge(dart.getEdge())) continue;
            return f;
        }
        return null;
    }

    public Face getOuterFace() {
        for (Face face : this.faces) {
            if (!face.isOuterFace()) continue;
            return face;
        }
        return null;
    }
}

