/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.EvaluatorException;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventListenersContainer
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EventListenersContainer.class);
    private final Map<String, Handlers> eventHandlers_ = new HashMap<String, Handlers>();
    private final SimpleScriptable jsNode_;

    EventListenersContainer(SimpleScriptable jsNode) {
        this.jsNode_ = jsNode;
    }

    public boolean addEventListener(String type, Function listener, boolean useCapture) {
        if (null == listener) {
            boolean accept = this.jsNode_.getWindow().getWebWindow().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ADD_EVENT_LISTENER_ACCEPTS_NULL_LISTENER);
            if (accept) {
                return true;
            }
            throw new EvaluatorException("Could not convert JavaScript argument (Listner was null).");
        }
        List<Function> listeners = this.getHandlersOrCreateIt(type).getHandlers(useCapture);
        if (listeners.contains(listener)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(type + " listener already registered, skipping it (" + listener + ")");
            }
            return false;
        }
        listeners.add(listener);
        return true;
    }

    private Handlers getHandlersOrCreateIt(String type) {
        Handlers handlers = this.eventHandlers_.get(type.toLowerCase());
        if (handlers == null) {
            handlers = new Handlers();
            this.eventHandlers_.put(type.toLowerCase(), handlers);
        }
        return handlers;
    }

    private List<Function> getHandlers(String eventType, boolean useCapture) {
        Handlers handlers = this.eventHandlers_.get(eventType.toLowerCase());
        if (handlers != null) {
            return handlers.getHandlers(useCapture);
        }
        return null;
    }

    public void removeEventListener(String type, Function listener, boolean useCapture) {
        List<Function> handlers = this.getHandlers(type, useCapture);
        if (handlers != null) {
            handlers.remove(listener);
        }
    }

    public void setEventHandlerProp(String eventName, Object value) {
        Handlers handlers = this.getHandlersOrCreateIt(eventName);
        handlers.handler_ = value;
    }

    public Object getEventHandlerProp(String eventName) {
        Handlers handlers = this.eventHandlers_.get(eventName);
        if (handlers == null) {
            return null;
        }
        return handlers.handler_;
    }

    private ScriptResult executeEventListeners(boolean useCapture, Event event, Object[] args) {
        Object node = this.jsNode_.getDomNodeOrDie();
        if (!event.applies((DomNode)node)) {
            return null;
        }
        ScriptResult allResult = null;
        List<Function> handlers = this.getHandlers(event.getType(), useCapture);
        if (handlers != null && !handlers.isEmpty()) {
            boolean ie = this.jsNode_.getWindow().getWebWindow().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_40);
            event.setCurrentTarget(this.jsNode_);
            HtmlPage page = (HtmlPage)((DomNode)node).getPage();
            ArrayList<Function> handlersToExecute = new ArrayList<Function>(handlers);
            for (Function listener : handlersToExecute) {
                ScriptResult result = page.executeJavaScriptFunctionIfPossible(listener, this.jsNode_, args, (DomNode)node);
                if (event.isPropagationStopped()) {
                    allResult = result;
                }
                if (!ie) continue;
                if (ScriptResult.isFalse(result)) {
                    allResult = result;
                    continue;
                }
                Object eventReturnValue = event.getReturnValue();
                if (!(eventReturnValue instanceof Boolean) || ((Boolean)eventReturnValue).booleanValue()) continue;
                allResult = new ScriptResult(Boolean.FALSE, page);
            }
        }
        return allResult;
    }

    private ScriptResult executeEventHandler(Event event, Object[] propHandlerArgs) {
        Object node = this.jsNode_.getDomNodeOrDie();
        if (!event.applies((DomNode)node)) {
            return null;
        }
        Function handler = this.getEventHandler(event.getType());
        if (handler != null) {
            event.setCurrentTarget(this.jsNode_);
            HtmlPage page = (HtmlPage)((DomNode)node).getPage();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing " + event.getType() + " handler for " + node);
            }
            return page.executeJavaScriptFunctionIfPossible(handler, this.jsNode_, propHandlerArgs, page);
        }
        return null;
    }

    public ScriptResult executeBubblingListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        ScriptResult newResult;
        ScriptResult result = null;
        Object domNode = this.jsNode_.getDomNodeOrDie();
        if (!(domNode instanceof HtmlBody)) {
            result = this.executeEventHandler(event, propHandlerArgs);
            if (event.isPropagationStopped()) {
                return result;
            }
        }
        if ((newResult = this.executeEventListeners(false, event, args)) != null) {
            result = newResult;
        }
        return result;
    }

    public ScriptResult executeCapturingListeners(Event event, Object[] args) {
        return this.executeEventListeners(true, event, args);
    }

    public Function getEventHandler(String eventName) {
        Object handler = this.getEventHandlerProp(eventName.toLowerCase());
        if (handler instanceof Function) {
            return (Function)handler;
        }
        return null;
    }

    public boolean hasEventHandlers(String eventName) {
        Handlers h = this.eventHandlers_.get(eventName);
        return h != null && (h.handler_ instanceof Function || !h.bubblingHandlers_.isEmpty() || !h.capturingHandlers_.isEmpty());
    }

    public ScriptResult executeListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        event.setEventPhase((short)1);
        ScriptResult result = this.executeEventListeners(true, event, args);
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)2);
        ScriptResult newResult = this.executeEventHandler(event, propHandlerArgs);
        if (newResult != null) {
            result = newResult;
        }
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)3);
        newResult = this.executeEventListeners(false, event, args);
        if (newResult != null) {
            result = newResult;
        }
        return result;
    }

    void copyFrom(EventListenersContainer eventListenersContainer) {
        for (Map.Entry<String, Handlers> entry : eventListenersContainer.eventHandlers_.entrySet()) {
            Handlers handlers = entry.getValue().clone();
            this.eventHandlers_.put(entry.getKey(), handlers);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node=" + this.jsNode_ + " handlers=" + this.eventHandlers_.keySet() + "]";
    }

    static class Handlers
    implements Serializable {
        private final List<Function> capturingHandlers_ = new ArrayList<Function>();
        private final List<Function> bubblingHandlers_ = new ArrayList<Function>();
        private Object handler_;

        Handlers() {
        }

        List<Function> getHandlers(boolean useCapture) {
            if (useCapture) {
                return this.capturingHandlers_;
            }
            return this.bubblingHandlers_;
        }

        protected Handlers clone() {
            Handlers clone = new Handlers();
            clone.handler_ = this.handler_;
            clone.capturingHandlers_.addAll(this.capturingHandlers_);
            clone.bubblingHandlers_.addAll(this.bubblingHandlers_);
            return clone;
        }
    }
}

