/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;
import org.zkoss.zk.ui.util.ConventionWires;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorComposer<T extends Component>
implements Composer<T>,
ComposerExt<T>,
ComponentCloneListener,
ComponentActivationListener,
Serializable {
    private static final long serialVersionUID = 5022810317492589463L;
    private static final String ON_WIRE_CLONE = "onWireCloneSelectorComposer";
    private static final String COMPOSER_CLONE = "COMPOSER_CLONE";
    private T _self;
    protected final List<VariableResolver> _resolvers = Selectors.newVariableResolvers(this.getClass(), SelectorComposer.class);
    private Object _subsInfo;
    private static Method _alert;
    private static final String UTILITY_HANDLER_KEY = "org.zkoss.zk.ui.select.SelectorComposer.UtilityHandler.class";
    private static UtilityHandler _handler;

    @Override
    public ComponentInfo doBeforeCompose(Page page, Component parent, ComponentInfo compInfo) {
        Selectors.wireVariables(page, (Object)this, this._resolvers);
        this._subsInfo = SelectorComposer.getUtilityHandler().subscribeEventQueues(this);
        return compInfo;
    }

    @Override
    public void doBeforeComposeChildren(T comp) throws Exception {
        this._self = comp;
        ConventionWires.wireController(comp, this);
    }

    @Override
    public void doAfterCompose(T comp) throws Exception {
        this._self = comp;
        Selectors.wireComponents(comp, (Object)this, false);
        Selectors.wireEventListeners(comp, this);
        if (this._subsInfo != null) {
            SelectorComposer.getUtilityHandler().postSubscriptionHandling(this._subsInfo, this._self);
            this._subsInfo = null;
        }
        comp.addEventListener(1000, "onCreate", new BeforeCreateWireListener());
        comp.addEventListener("onCreate", new AfterCreateWireListener());
    }

    protected T getSelf() {
        return this._self;
    }

    protected Page getPage() {
        Page page;
        if (this._self != null && (page = this._self.getPage()) != null) {
            return page;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? ((ExecutionCtrl)((Object)exec)).getCurrentPage() : null;
    }

    protected void alert(String m) {
        try {
            if (_alert == null) {
                Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                _alert = mboxcls.getMethod("show", String.class);
            }
            _alert.invoke(null, m);
        }
        catch (InvocationTargetException e) {
            throw UiException.Aide.wrap(e);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object willClone(Component comp) {
        try {
            Execution exec = Executions.getCurrent();
            int idcode = System.identityHashCode(comp);
            Composer composerClone = (Composer)exec.getAttribute(COMPOSER_CLONE + idcode);
            if (composerClone == null) {
                composerClone = (Composer)Classes.newInstance(this.getClass(), null);
                exec.setAttribute(COMPOSER_CLONE + idcode, composerClone);
                AbstractComponent post = new AbstractComponent();
                CloneDoAfterCompose l = new CloneDoAfterCompose();
                Event evt = new Event(ON_WIRE_CLONE, post, new Object[]{comp, composerClone});
                post.addEventListener(ON_WIRE_CLONE, l);
                Events.postEvent(evt);
            }
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    public void didActivate(Component comp) {
        Selectors.rewireComponentsOnActivate(comp, this);
        Selectors.rewireVariablesOnActivate(comp, this, this._resolvers);
        Selectors.rewireEventListeners(comp, this);
        Object subsInfo = SelectorComposer.getUtilityHandler().resubscribeEventQueues(this);
        if (subsInfo != null) {
            SelectorComposer.getUtilityHandler().postSubscriptionHandling(subsInfo, comp);
        }
    }

    @Override
    public void willPassivate(Component comp) {
    }

    @Override
    public boolean doCatch(Throwable ex) throws Exception {
        return false;
    }

    @Override
    public void doFinally() throws Exception {
    }

    protected static UtilityHandler getUtilityHandler() {
        SelectorComposer.loadUtilityHandler();
        return _handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadUtilityHandler() {
        if (_handler != null) {
            return;
        }
        Class<SelectorComposer> clazz = SelectorComposer.class;
        synchronized (SelectorComposer.class) {
            if (_handler != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            String clsName = Library.getProperty((String)UTILITY_HANDLER_KEY);
            if (clsName != null) {
                try {
                    Object o = Classes.newInstanceByThread((String)clsName);
                    if (!(o instanceof UtilityHandler)) {
                        _handler = new UtilityHandlerImpl();
                        throw new UiException(o.getClass().getName() + " must implement " + UtilityHandler.class.getName());
                    }
                    _handler = (UtilityHandler)o;
                }
                catch (Exception ex) {
                    _handler = new UtilityHandlerImpl();
                    throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + clsName);
                }
            } else {
                _handler = new UtilityHandlerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static class UtilityHandlerImpl
    implements UtilityHandler {
        private static final long serialVersionUID = 1L;

        public Object subscribeEventQueues(Object controller) {
            return null;
        }

        public Object resubscribeEventQueues(Object controller) {
            return null;
        }

        public void postSubscriptionHandling(Object subsInfo, Object target) {
        }
    }

    public static interface UtilityHandler {
        public Object subscribeEventQueues(Object var1);

        public Object resubscribeEventQueues(Object var1);

        public void postSubscriptionHandling(Object var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloneDoAfterCompose
    implements SerializableEventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CloneDoAfterCompose() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            event.getTarget().removeEventListener(SelectorComposer.ON_WIRE_CLONE, this);
            Component clone = (Component)((Object[])event.getData())[0];
            SelectorComposer composerClone = (SelectorComposer)((Object[])event.getData())[1];
            ConventionWires.wireController(clone, composerClone);
            Selectors.wireVariables(clone.getPage(), (Object)this, composerClone._resolvers);
            Selectors.wireComponents(clone, (Object)this, false);
            Selectors.wireEventListeners(clone, this);
            Object subsInfo = SelectorComposer.getUtilityHandler().subscribeEventQueues(composerClone);
            if (subsInfo != null) {
                SelectorComposer.getUtilityHandler().postSubscriptionHandling(subsInfo, clone);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AfterCreateWireListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1L;

        private AfterCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Selectors.wireEventListeners(SelectorComposer.this._self, SelectorComposer.this);
            SelectorComposer.this._self.removeEventListener("onCreate", this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeforeCreateWireListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 1L;

        private BeforeCreateWireListener() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Selectors.wireComponents(event.getTarget(), (Object)SelectorComposer.this, true);
            SelectorComposer.this._self.removeEventListener("onCreate", this);
        }
    }
}

