
zk.copy(zk, (function() {
	var _loaded = {'zk': true}, 
		_xloadings = [], 
		_loadedsemis = [], 
		_afterLoadFronts = [],
		_afterLoads = [],
		_afterPkgLoad = {}, 
		_pkgdepend = {},
		_pkgver = {},
		_pkghosts = {}, _defhost = [],
		_loading = zk.copy({'zul.lang': true}, _loaded); 

	
	
	function markLoading(nm) {
		
		_loading[nm] = true;

		_xloadings.push(nm);
		if (updCnt() == 1) {
			zk.disableESC();
		}
	}
	function doEnd(afs, wait) {
		for (var fn; fn = afs.shift();) {
			if (updCnt() || (wait && _loadedsemis.length)) {
				afs.unshift(fn);
				return;
			}
			fn();
		}
	}
	function updCnt() {
		return (zk.loading = _xloadings.length);
	}

  return { 
	setLoaded: _zkf = function (pkg, wait) { 
		_xloadings.$remove(pkg);
		_loading[pkg] = true;

		if (wait) {
			if (!_loaded[pkg]) _loadedsemis.push(pkg);
		} else {
			_loadedsemis.$remove(pkg);
			_loaded[pkg] = true;

			var afpk = _afterPkgLoad[pkg];
			if (afpk) {
				delete _afterPkgLoad[pkg];
				_afterLoadFronts.$addAll(afpk);
			}

			var deps = _pkgdepend[pkg];
			if (deps) {
				delete _pkgdepend[pkg];
				for (var pn; pn = deps.unshift();)
					zk.load(pn);
			}
		}

		if (!updCnt()) {
			try {
				zk.enableESC();
			} catch (ex) {
			}
			doEnd(_afterLoadFronts);
			doEnd(_afterLoads, 1);
		}
	},
	
	setScriptLoaded: _zkf,

	
	isLoaded: function (pkg, loading) {
		return (loading && _loading[pkg]) || _loaded[pkg];
	},
	
	
	load: function (pkg, dt, func) {
		if (typeof dt == 'function')
			if (func) throw 'At most one function allowed';
			else {
				func = dt;
				dt = null;
			}

		if (func) zk.afterLoad(pkg, func, true);

		var loading;
		for (var pkgs = pkg.split(','), j = pkgs.length; j--;) {
			pkg = pkgs[j].trim();
			if (!zk._load(pkg, dt))
				loading = true;
		}
		return !loading;
	},
	_load: function (pkg, dt) { 
		if (!pkg || _loading[pkg])
			return !zk.loading && !_loadedsemis.length;
			

		markLoading(pkg);

		var modver = zk.getVersion(pkg) || zk.build,
			e = document.createElement('script'),
			uri = pkg + '.wpd',
			host = zk.getHost(pkg, true);
		e.type = 'text/javascript';
		e.charset = 'UTF-8';

		if (uri.charAt(0) != '/') uri = '/' + uri;

		if (host) uri = host + '/web/js' + uri;
		else {
			if (modver) uri = '/web/_zv' + modver + '/js' + uri;
			else uri = '/web/js' + uri;
			uri = zk.ajaxURI(uri, {desktop:dt,au:true});
		}

		e.src = uri;
		jq.head().appendChild(e);
		return false;
	},

	
	loadScript: function (src, name, charset) {
		if (name)
			markLoading(name);

		var e = document.createElement('script');
		e.type = 'text/javascript';
		e.charset = charset || 'UTF-8';
		e.src = src;
		jq.head().appendChild(e);
		return this;
	},
	
	loadCSS: function (href, id, media) {
		var ln = document.createElement('link');
		if (id) ln.id = id;
		ln.rel = 'stylesheet';
		ln.type = 'text/css';
		ln.href = href;
		if (media) ln.media = media;
		jq.head().appendChild(ln);
		return this;
	},

	
	getVersion: function (pkg) {
		for (var ver; pkg; pkg = pkg.substring(0, pkg.lastIndexOf('.')))
			if (ver = _pkgver[pkg])
				return ver;
	},
	
	setVersion: function (pkg, ver) {
		_pkgver[pkg] = ver;
	},
	
	depends: function (a, b) {
		if (a && b) 
			if (_loaded[a]) zk.load(b);
			else {
				if (_pkgdepend[a]) _pkgdepend[a].push(b);
				else _pkgdepend[a] = [b];
			}
	},

	
	
	afterLoad: function (a, b, front) {
		if (typeof a == 'string') {
			if (!b) return true;

			for (var pkgs = a.split(','), j = pkgs.length; j--;) {
				var p = pkgs[j].trim();
				if (p && !_loaded[p]) {
					while (j--) {
						var p2 = pkgs[j].trim();
						if (p2 && !_loaded[p2]) { 
							var a1 = a, b1 = b;
							b = function () {
								zk.afterLoad(a1, b1, front); 
							};
							break;
						}
					}

					if (_afterPkgLoad[p]) _afterPkgLoad[p].push(b);
					else _afterPkgLoad[p] = [b];
					return false;
				}
			}

			
			a = b;
		}

		if (a) {
			if (zk.loading || _loadedsemis.length) {
				(front ? _afterLoadFronts: _afterLoads).push(a);
				return false;
			}
			a(); 
			return true;
		}
	},
	
	getHost: function (pkg, js) {
		for (var p in _pkghosts)
			if (pkg.startsWith(p))
				return _pkghosts[p][js ? 1: 0];
		return _defhost[js ? 1: 0];
	},
	
	setHost: function (host, updURI, pkgs) {
		var hostUpd = host + updURI;
		if (!_defhost.length)
			for (var scs = document.getElementsByTagName('script'), j = 0, len = scs.length;
			j < len; ++j) {
				var src = scs[j].src;
				if (src)
					if (src.startsWith(host)) {
						_defhost = [host, hostUpd];
						break;
					} else if (src.indexOf('/zk.wpd') >= 0)
						break;
			}
		for (var j = 0; j < pkgs.length; ++j)
			_pkghosts[pkgs[j]] = [host, hostUpd];
	}
  }
})());
