/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator;

import fit.Parse;
import fit.decorator.CopyAndAppendLastRow;
import fit.decorator.FixtureDecorator;
import fit.decorator.FixtureDecoratorTestCase;
import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.TestCaseHelper;

public class CopyAndAppendLastRowTest
extends FixtureDecoratorTestCase {
    private static final String FIRST_HTML_ROW = "<tr><td>" + CopyAndAppendLastRow.class.getName() + "</td><td>0</td><td>times</td></tr>";
    private static final int COUNTER = 5;
    private FixtureDecorator decorator = new CopyAndAppendLastRow();

    @Override
    protected String geDecoratorHTMLRow() {
        return FIRST_HTML_ROW;
    }

    @Override
    protected int numberOfAssertionsOnDecorator() {
        return 0;
    }

    public void testSetupDecoratorShouldThrowInvalidInputExceptionIfCounterIsNotSpecified() {
        try {
            this.decorator.setupDecorator(new String[0]);
            CopyAndAppendLastRowTest.fail((String)"Should blow up");
        }
        catch (InvalidInputException e) {
            CopyAndAppendLastRowTest.assertEquals((String)"Count for number of times to add the last row must be specified", (String)e.getMessage());
        }
    }

    public void testSetupDecoratorShouldAddCounterToSummary() throws Exception {
        this.decorator.setupDecorator(new String[]{String.valueOf(5)});
        CopyAndAppendLastRowTest.assertEquals((int)5, (int)((Integer)this.decorator.summary.get("numberOfTimes")));
    }

    public void testShouldLeaveTableAsItIsIfCounterValueIsZero() throws Exception {
        String fitPage = "<table>" + FIRST_HTML_ROW + "<tr><td>fit.decorator.TestFixture</td></tr></table>";
        this.decorator.doTables(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(0, 0, 0, 0), this.decorator.counts);
    }

    public void testShouldAddOneRowIfCounterValueIsOne() throws Exception {
        String fitPage = "<table><tr><td>" + CopyAndAppendLastRow.class.getName() + "</td><td>1" + "</td><td>times</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.decorator.doTables(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(2, 0, 0, 0), this.decorator.counts);
    }

    public void testShouldLeaveTableAsItIsIfTotalRowsAreLessThanThree() throws Exception {
        String fitPage = "<table><tr><td>" + CopyAndAppendLastRow.class.getName() + "</td>" + "<td>0</td><td>times</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr></table>";
        this.decorator.doTables(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(0, 0, 0, 0), this.decorator.counts);
    }

    public void testShouldAppendLastRowCounterNumberOfTimes() throws Exception {
        String fitPage = "<table><tr><td>" + CopyAndAppendLastRow.class.getName() + "</td><td>" + 5 + "</td><td>times</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(6, 0, 0, 0), this.decorator.counts);
    }

    public void testShouldAppendOnlyTheLastRowCounterNumberOfTimes() throws Exception {
        String fitPage = "<table><tr><td>" + CopyAndAppendLastRow.class.getName() + "</td><td>" + 5 + "</td><td>times</td></tr><tr><td>eg.Division</td></tr>" + "<tr><td>numerator</td><td>denominator</td><td>quotient()</td></tr>" + "<tr><td>10</td><td>2</td><td>5</td></tr><tr><td>12.6</td><td>3</td><td>4.2</td></tr>" + "<tr><td>100</td><td>4</td><td>25</td></tr></table>";
        this.decorator.doTable(new Parse(fitPage));
        TestCaseHelper.assertCounts(TestCaseHelper.counts(8, 0, 0, 0), this.decorator.counts);
    }
}

