/*
 * Decompiled with CFR 0.152.
 */
package fit.decorator.util;

import fit.decorator.exceptions.InvalidInputException;
import fit.decorator.util.DataType;
import fit.decorator.util.PointDataType;
import java.awt.Point;
import junit.framework.TestCase;

public class DataTypeTest
extends TestCase {
    public void testInstanceMethodReturnsValidDataTypeForGivenParam() throws Exception {
        DataTypeTest.assertSame((Object)DataType.INTEGER, (Object)DataType.instance("int"));
        DataTypeTest.assertSame((Object)DataType.INTEGER, (Object)DataType.instance("Int"));
        DataTypeTest.assertSame((Object)DataType.INTEGER, (Object)DataType.instance("integer"));
        DataTypeTest.assertSame((Object)DataType.INTEGER, (Object)DataType.instance("INTEGER"));
        DataTypeTest.assertSame((Object)DataType.DOUBLE, (Object)DataType.instance("double"));
        DataTypeTest.assertSame((Object)DataType.DOUBLE, (Object)DataType.instance("DOUBLE"));
        DataTypeTest.assertSame((Object)DataType.STRING, (Object)DataType.instance("string"));
        DataTypeTest.assertSame((Object)DataType.STRING, (Object)DataType.instance("STRING"));
        DataTypeTest.assertSame((Object)DataType.DATE, (Object)DataType.instance("DATE"));
    }

    public void testInstanceMethodDefaultsDataTypeToSTRINGIfGivenParamIsInvalid() throws Exception {
        DataTypeTest.assertSame((Object)DataType.STRING, (Object)DataType.instance("invalid"));
    }

    public void testParseMethodParsesInputStringAndConvertsItToAppropriateObject() throws Exception {
        Object parsedObject = DataType.INTEGER.parse("10");
        DataTypeTest.assertEquals((int)10, (int)((Integer)parsedObject));
        parsedObject = DataType.DOUBLE.parse("10.3");
        DataTypeTest.assertEquals((double)10.3, (double)((Double)parsedObject), (double)0.01);
        parsedObject = DataType.STRING.parse("Some String");
        DataTypeTest.assertEquals((String)"Some String", (String)((String)parsedObject));
        parsedObject = DataType.DATE.parse("10");
        DataTypeTest.assertEquals((int)10, (int)((Integer)parsedObject));
    }

    public void testParseMethodThrowsInvalidInputExceptionIfInputStringIsCannotBeParsed() throws Exception {
        this.assertInvalidInputException("Invalid Integer", DataType.INTEGER, "int");
        this.assertInvalidInputException("1.2", DataType.INTEGER, "int");
        this.assertInvalidInputException("Invalid Double", DataType.DOUBLE, "double");
        this.assertInvalidInputException("1.2E", DataType.DOUBLE, "double");
        this.assertInvalidInputException("12-2-2006", DataType.DATE, "date");
    }

    private void assertInvalidInputException(String value, DataType dataType, String dataTypeString) {
        try {
            dataType.parse(value);
            DataTypeTest.fail((String)("Should have thrown InvalidInputException since '" + value + "' is not a valid " + dataTypeString));
        }
        catch (InvalidInputException e) {
            DataTypeTest.assertEquals((String)("value '" + value + "' is not a valid DataType = '" + dataTypeString + "'"), (String)e.getMessage());
        }
    }

    public void testAddToMethodAddsGivenValueGivenNumberOfTimesToOriginalValue() throws Exception {
        DataTypeTest.assertEquals((String)"10", (String)DataType.INTEGER.addTo("10", new Integer(5), 0));
        DataTypeTest.assertEquals((String)"15", (String)DataType.INTEGER.addTo("10", new Integer(5), 1));
        DataTypeTest.assertEquals((String)"20", (String)DataType.INTEGER.addTo("10", new Integer(5), 2));
        DataTypeTest.assertEquals((String)"10.2", (String)DataType.DOUBLE.addTo("10.2", new Double(5.1), 0));
        DataTypeTest.assertEquals((String)"15.3", (String)DataType.DOUBLE.addTo("10.2", new Double(5.1), 1));
        DataTypeTest.assertEquals((String)"20.4", (String)DataType.DOUBLE.addTo("10.2", new Double(5.1), 2));
        DataTypeTest.assertEquals((String)"Hello", (String)DataType.STRING.addTo("Hello", " World", 0));
        DataTypeTest.assertEquals((String)"Hello World", (String)DataType.STRING.addTo("Hello", " World", 1));
        DataTypeTest.assertEquals((String)"Hello World World", (String)DataType.STRING.addTo("Hello", " World", 2));
        DataTypeTest.assertEquals((String)"12/02/2006", (String)DataType.DATE.addTo("12/02/2006", new Integer(5), 0));
        DataTypeTest.assertEquals((String)"12/07/2006", (String)DataType.DATE.addTo("12/02/2006", new Integer(5), 1));
        DataTypeTest.assertEquals((String)"01/01/2007", (String)DataType.DATE.addTo("12/31/2006", new Integer(1), 1));
        DataTypeTest.assertEquals((String)"01/21/2007", (String)DataType.DATE.addTo("12/02/2006", new Integer(5), 10));
    }

    public void testShouldBeAbleToAddCustomDataTypes() throws Exception {
        DataType.registerUserDefinedDataTypes(Point.class.getName(), new PointDataType());
        DataType returnedDataType = DataType.instance(Point.class.getName());
        DataTypeTest.assertEquals((String)"(5,5)", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 0));
        DataTypeTest.assertEquals((String)"(6,6)", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 1));
        DataTypeTest.assertEquals((String)"(10,10)", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 5));
    }

    public void testShouldBeAbleToRemoveSpecificCustomDataTypes() throws Exception {
        DataType.registerUserDefinedDataTypes(Point.class.getName(), new PointDataType());
        DataType returnedDataType = DataType.instance(Point.class.getName());
        DataTypeTest.assertEquals((String)"(6,6)", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 1));
        DataType.clearUserDefinedDataTypes(Point.class.getName());
        returnedDataType = DataType.instance(Point.class.getName());
        DataTypeTest.assertEquals((String)"(5,5)java.awt.Point[x=1,y=1]", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 1));
    }

    public void testShouldBeAbleToRemoveAllCustomDataTypes() throws Exception {
        DataType.registerUserDefinedDataTypes(Point.class.getName(), new PointDataType());
        DataType returnedDataType = DataType.instance(Point.class.getName());
        DataTypeTest.assertEquals((String)"(6,6)", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 1));
        DataType.clearUserDefinedDataTypes();
        returnedDataType = DataType.instance(Point.class.getName());
        DataTypeTest.assertEquals((String)"(5,5)java.awt.Point[x=1,y=1]", (String)returnedDataType.addTo("(5,5)", new Point(1, 1), 1));
    }
}

