/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.batch;

import fitlibrary.batch.FitLibraryRunner;
import java.security.InvalidParameterException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

public class TestFitLibraryRunner {
    @Test
    public void validRunParametersWithDefaults() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"runnerResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)"80"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RETRIES), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.JUNIT_XML_OUTPUT), (Matcher)CoreMatchers.is((Object)"false"));
    }

    @Test(expected=InvalidParameterException.class)
    public void missingSuiteName() {
        String[] stringArray = new String[]{};
        FitLibraryRunner.getRunParameters(stringArray);
    }

    @Test
    public void fitNesseDiryIsAlsoGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-fitNesseDiry", "../.."};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"../.."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"runnerResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)"80"));
    }

    @Test
    public void resultsDiryIsAlsoGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-resultsDiry", "TheResults"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"TheResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)"80"));
    }

    @Test
    public void showPassesIsAlsoGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-showPasses", "true"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"runnerResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)runParameters.getInt(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)80));
        MatcherAssert.assertThat((Object)runParameters.getInt(FitLibraryRunner.RunParameters.ValidParameters.RETRIES), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void retriesIsAlsoGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-retries", "2"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"runnerResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)runParameters.getInt(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)80));
        MatcherAssert.assertThat((Object)runParameters.getInt(FitLibraryRunner.RunParameters.ValidParameters.RETRIES), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void portIsAlsoGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-port", "8990"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"runnerResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"false"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)"8990"));
    }

    @Test(expected=NumberFormatException.class)
    public void portIsGivenIncorrectly() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-port", "abc"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        runParameters.getInt(FitLibraryRunner.RunParameters.ValidParameters.PORT);
    }

    @Test
    public void allAreGiven() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-fitNesseDiry", "../..", "-resultsDiry", "TheResults", "-showPasses", "true", "-port", "8990", "-retries", "11", "-junitXmlOutput", "true"};
        FitLibraryRunner.RunParameters runParameters = FitLibraryRunner.getRunParameters(stringArray);
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SUITE_NAME), (Matcher)CoreMatchers.is((Object)"Suite.Name"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.FIT_NESSE_DIRY), (Matcher)CoreMatchers.is((Object)"../.."));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RESULTS_DIRY), (Matcher)CoreMatchers.is((Object)"TheResults"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.SHOW_PASSES), (Matcher)CoreMatchers.is((Object)"true"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.PORT), (Matcher)CoreMatchers.is((Object)"8990"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.RETRIES), (Matcher)CoreMatchers.is((Object)"11"));
        MatcherAssert.assertThat((Object)runParameters.get(FitLibraryRunner.RunParameters.ValidParameters.JUNIT_XML_OUTPUT), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Test
    public void unknownParameter() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-portly", "8990"};
        try {
            FitLibraryRunner.getRunParameters(stringArray);
            Assert.fail();
        }
        catch (InvalidParameterException invalidParameterException) {
            MatcherAssert.assertThat((Object)invalidParameterException.getMessage(), (Matcher)JUnitMatchers.containsString((String)"portly"));
        }
    }

    @Test
    public void missingValue() {
        String[] stringArray = new String[]{"-suiteName", "Suite.Name", "-port"};
        try {
            FitLibraryRunner.getRunParameters(stringArray);
            Assert.fail();
        }
        catch (InvalidParameterException invalidParameterException) {
            MatcherAssert.assertThat((Object)invalidParameterException.getMessage(), (Matcher)JUnitMatchers.containsString((String)"port"));
        }
    }

    @Test
    public void formatTimeWhenLessThanOneSecond() {
        MatcherAssert.assertThat((Object)FitLibraryRunner.formatTime(678L), (Matcher)CoreMatchers.is((Object)"678 milliseconds."));
    }

    @Test
    public void formatTimeWhenLessThanMinute() {
        MatcherAssert.assertThat((Object)FitLibraryRunner.formatTime(11678L), (Matcher)CoreMatchers.is((Object)"11 seconds (11678 milliseconds)."));
    }

    @Test
    public void formatTimeWhenLessThanHour() {
        MatcherAssert.assertThat((Object)FitLibraryRunner.formatTime(101678L), (Matcher)CoreMatchers.is((Object)"1 minutes 41 seconds (101678 milliseconds)."));
    }

    @Test
    public void formatTimeWhenGreaterThanHour() {
        MatcherAssert.assertThat((Object)FitLibraryRunner.formatTime(10802345L), (Matcher)CoreMatchers.is((Object)"3 hours 0 minutes 2 seconds (10802345 milliseconds)."));
    }
}

