/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.method.VoidMethodException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DoTraverse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionSetUpTraverse
extends DoTraverse {
    protected ICalledMethodTarget target;
    protected int argCount = -1;
    protected boolean boundOK = false;
    protected Collection<Object> collection = new ArrayList<Object>();
    protected boolean embedded = false;

    public CollectionSetUpTraverse() {
    }

    public CollectionSetUpTraverse(Collection<Object> collection) {
        this.collection = collection;
    }

    public CollectionSetUpTraverse(Object sut, Collection<Object> collection, boolean embedded) {
        super(sut);
        this.collection = collection;
        this.embedded = embedded;
    }

    public CollectionSetUpTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.bindFirstRowToTarget((Row)table.at(1), testResults, this);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow((Row)table.at(i), testResults);
        }
        return this.collection;
    }

    @Override
    public Object interpretInFlow(Table table, TestResults testResults) {
        try {
            this.interpretAfterFirstRow(table, testResults);
        }
        catch (Exception e) {
            int rowNo = 0;
            if (this.embedded) {
                rowNo = 1;
            }
            ((Row)table.at(rowNo)).error(testResults, e);
        }
        return this.collection;
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults, Evaluator evaluator) {
        try {
            this.argCount = row.size();
            this.target = CollectionSetUpTraverse.findMethodTarget(row, evaluator, this.embedded);
            this.boundOK = true;
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    private static ICalledMethodTarget findMethodTarget(Row row, Evaluator evaluator, boolean embedded) {
        ArrayList<String> arguments = new ArrayList<String>();
        String argNames = CollectionSetUpTraverse.buildArguments(row, arguments, evaluator);
        String methodName = evaluator.getRuntimeContext().extendedCamel(argNames);
        ICalledMethodTarget findMethod = PlugBoard.lookupTarget.findMethod(methodName, arguments, "Type", evaluator);
        if (findMethod.returnsVoid() && embedded) {
            throw new VoidMethodException(methodName, "SetUpTraverse");
        }
        return findMethod;
    }

    private static String buildArguments(Row row, List<String> arguments, Evaluator evaluator) {
        String argNames = "";
        for (int i = 0; i < row.size(); ++i) {
            String name = row.text(i, evaluator);
            argNames = argNames + " " + name;
            arguments.add(evaluator.getRuntimeContext().extendedCamel(name));
        }
        return argNames;
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.boundOK) {
            row.ignore(testResults);
            return;
        }
        if (row.size() != this.argCount) {
            row.error(testResults, new RowWrongWidthException(this.argCount));
            return;
        }
        try {
            this.invokeMethod(row, testResults);
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    public Object invokeMethod(Row row, TestResults testResults) throws Exception {
        Object result = this.target().invoke(row, testResults, true);
        this.collection.add(result);
        return result;
    }

    public ICalledMethodTarget target() {
        return this.target;
    }

    public Collection<Object> getCollection() {
        return this.collection;
    }

    public static boolean hasObjectFactoryMethodFor(Table table, Evaluator evaluator) {
        try {
            CollectionSetUpTraverse.findMethodTarget((Row)table.at(0), evaluator, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

