/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.collection.map;

import fitlibrary.exception.table.ExtraCellsException;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.Typed;
import java.util.HashMap;
import java.util.Map;

public class MapTraverse
extends Traverse {
    private Map<Object, Object> map;
    protected Parser keyParser;
    protected Parser valueParser;

    public MapTraverse(Map<Object, Object> map) {
        this.map = map;
    }

    public MapTraverse(Map<Object, Object> map, Typed keyTyped, Typed valueTyped, RuntimeContextInternal runtimeContext) {
        this(map);
        this.runtimeContext = runtimeContext;
        this.keyParser = keyTyped.parser(this);
        this.valueParser = valueTyped.parser(this);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        if (this.map.isEmpty()) {
            if (table.size() == 1) {
                table.pass(testResults);
            } else {
                for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
                    ((Row)table.at(rowNo)).missing(testResults);
                }
            }
        } else {
            this.determineTypes();
            HashMap<Object, Object> copiedMap = new HashMap<Object, Object>(this.map);
            for (int rowNo = 1; rowNo < table.size(); ++rowNo) {
                this.interpret((Row)table.at(rowNo), copiedMap, this.keyParser, testResults);
            }
            this.addSurplusRows(table, copiedMap, testResults);
        }
        return this.map;
    }

    protected void determineTypes() {
        if (this.keyParser != null) {
            return;
        }
        Object someKey = this.map.keySet().iterator().next();
        this.keyParser = MapTraverse.asTyped(someKey).parser(this);
        this.valueParser = MapTraverse.asTyped(this.map.get(someKey)).parser(this);
    }

    private void interpret(Row row, Map<Object, Object> copiedMap, Parser keyParser2, TestResults testResults) {
        try {
            if (row.size() > 2) {
                throw new ExtraCellsException("MapTraverse");
            }
            Object key = keyParser2.parseTyped((Cell)row.at(0), testResults).getSubject();
            Object value = copiedMap.get(key);
            if (value == null) {
                ((Cell)row.at(0)).expectedElementMissing(testResults);
            } else {
                Parser valueParser3 = MapTraverse.asTyped(value).parser(this);
                if (valueParser3.matches((Cell)row.at(1), value, testResults)) {
                    row.pass(testResults);
                } else {
                    ((Cell)row.at(1)).fail(testResults, valueParser3.show(value), this);
                }
            }
            copiedMap.remove(key);
        }
        catch (Exception e) {
            row.error(testResults, e);
        }
    }

    protected void addSurplusRows(Table table, Map<Object, Object> surplus, TestResults testResults) {
        for (Object key : surplus.keySet()) {
            Object value = surplus.get(key);
            Row row = table.newRow();
            try {
                row.addCell(this.keyParser.show(key));
                row.addCell(this.valueParser.show(value));
                ((Cell)row.at(0)).actualElementMissing(testResults);
            }
            catch (Exception e) {
                if (row.isEmpty()) {
                    table.error(testResults, (Throwable)e);
                    continue;
                }
                row.error(testResults, e);
            }
        }
    }
}

