/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.runResults.TableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DefinedActionTraverse
extends Traverse {
    private Tables body;

    public DefinedActionTraverse() {
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        Row header = (Row)table.at(1);
        HashSet<String> parameterNames = new HashSet<String>();
        for (int c = 0; c < header.size(); ++c) {
            Cell parameterCell = (Cell)header.at(c);
            String parameterName = parameterCell.text(this);
            if (parameterNames.contains(parameterName)) {
                parameterCell.error(testResults, new FitLibraryException("Duplicate parameter names"));
            }
            parameterNames.add(parameterName);
        }
        return null;
    }

    protected DefinedActionTraverse(Table defTable, int parameterCount) {
        Row header = (Row)defTable.at(1);
        if (header.size() != parameterCount) {
            throw new FitLibraryException("Mismatch in number of parameters to template");
        }
        HashMap<String, Object> mapToRef = new HashMap<String, Object>();
        for (int c = 0; c < header.size(); ++c) {
            mapToRef.put(header.text(c, this), DefinedActionTraverse.paramRef(c));
        }
        this.body = TableFactory.tables(((Cell)((Row)defTable.at(2)).at(0)).getEmbeddedTables());
        this.macroReplace(this.body, mapToRef);
    }

    public Tables call(List<Object> parameters, TestResults results) {
        Tables copy = TableFactory.tables(this.body);
        this.substitute(parameters, copy);
        this.executeInstantiatedAction(results, copy);
        return copy;
    }

    protected void executeInstantiatedAction(TestResults results, Tables copy) {
        new BatchFitLibrary(new TableListener(results)).doTables(copy);
    }

    private void substitute(List<Object> parameters, Tables copy) {
        HashMap<String, Object> mapFromRef = new HashMap<String, Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            mapFromRef.put(DefinedActionTraverse.paramRef(i), parameters.get(i));
        }
        this.macroReplace(copy, mapFromRef);
    }

    private void macroReplace(Tables tables, Map<String, Object> mapToRef) {
        ArrayList<String> reverseSortOrder = new ArrayList<String>(mapToRef.keySet());
        Collections.sort(reverseSortOrder, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return arg1.compareTo(arg0);
            }
        });
        for (Table table : tables) {
            for (Row row : table) {
                for (Cell cell : row) {
                    String text = cell.text(this);
                    for (String key : reverseSortOrder) {
                        if (!text.contains(key)) continue;
                        Object value = mapToRef.get(key);
                        if (value instanceof Table) {
                            cell.setInnerTables(TableFactory.tables((Table)value));
                            continue;
                        }
                        text = text.replaceAll(key, (String)value);
                        cell.setText(text);
                    }
                }
            }
        }
    }

    private static String paramRef(int c) {
        return "%__%" + c + "%__%";
    }
}

