/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedAction;

import fitlibrary.definedAction.ParameterBinder;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.matcher.TablesMatcher;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.CollectionUtility;
import fitlibrary.utility.StringTablesPair;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestParameterBinder {
    Mockery context = new Mockery();
    protected DynamicVariables resolver = (DynamicVariables)this.context.mock(DynamicVariables.class);
    List<String> formals = new ArrayList<String>();
    Tables tables = TableFactory.tables();
    ParameterBinder binder = new ParameterBinder("name", this.formals, this.tables, "fileName");

    @Test
    public void fileName() {
        MatcherAssert.assertThat((Object)this.binder.getPageName(), (Matcher)CoreMatchers.is((Object)"fileName"));
        MatcherAssert.assertThat((Object)this.binder.getCopyOfBody(), this.isTables(this.tables));
    }

    private Matcher<Tables> isTables(Tables tables) {
        return new TablesMatcher(tables, this.resolver);
    }

    @Test(expected=FitLibraryException.class)
    public void unknownParameter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(1.returnValue((Object)new StringTablesPair("a")));
            }
        });
        this.formals.add("A");
        this.formals.add("B");
        this.binder.verifyHeaderAgainstFormalParameters(TableFactory.row("a", "b"), this.resolver);
    }

    @Test(expected=FitLibraryException.class)
    public void duplicateParameter() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(2.returnValue((Object)new StringTablesPair("a")));
            }
        });
        this.formals.add("a");
        this.formals.add("B");
        this.binder.verifyHeaderAgainstFormalParameters(TableFactory.row("a", "a"), this.resolver);
    }

    @Test(expected=FitLibraryException.class)
    public void wrongNumberOfFormalParameter() {
        this.formals.add("a");
        this.binder.verifyHeaderAgainstFormalParameters(TableFactory.row("a", "a"), this.resolver);
    }

    @Test
    public void validParameterNames() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(3.returnValue((Object)new StringTablesPair("a")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("b");
                this.will(3.returnValue((Object)new StringTablesPair("b")));
            }
        });
        this.formals.add("a");
        this.formals.add("b");
        this.binder.verifyHeaderAgainstFormalParameters(TableFactory.row("a", "b"), this.resolver);
    }

    @Test
    public void validParameterNamesInReverse() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(4.returnValue((Object)new StringTablesPair("a")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("b");
                this.will(4.returnValue((Object)new StringTablesPair("b")));
            }
        });
        this.formals.add("b");
        this.formals.add("a");
        this.binder.verifyHeaderAgainstFormalParameters(TableFactory.row("a", "b"), this.resolver);
    }

    @Test(expected=FitLibraryException.class)
    public void wrongNumberOfActualParameters() {
        this.formals.add("a");
        this.binder.bindMulti(TableFactory.row("a", "b"), TableFactory.row("1", "extra"), this.resolver);
    }

    @Test
    public void bindMultiWorks() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(5.returnValue((Object)new StringTablesPair("a")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("b");
                this.will(5.returnValue((Object)new StringTablesPair("b")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("1");
                this.will(5.returnValue((Object)new StringTablesPair("1")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("2");
                this.will(5.returnValue((Object)new StringTablesPair("2")));
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter("a", "1");
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter("b", "2");
            }
        });
        this.formals.add("a");
        this.formals.add("b");
        this.binder.bindMulti(TableFactory.row("a", "b"), TableFactory.row("1", "2"), this.resolver);
    }

    @Test
    public void bindMultiWorksWithNestedTable() {
        final Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("x")));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("a");
                this.will(6.returnValue((Object)new StringTablesPair("a")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("1");
                this.will(6.returnValue((Object)new StringTablesPair("22", tables)));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("x");
                this.will(6.returnValue((Object)new StringTablesPair("x")));
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter((String)this.with("a"), this.with((Matcher)new TablesMatcher(tables, TestParameterBinder.this.resolver)));
            }
        });
        this.formals.add("a");
        this.binder.bindMulti(TableFactory.row("a", "b"), TableFactory.row("1"), this.resolver);
    }

    @Test
    public void bindUniWorks() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("1");
                this.will(7.returnValue((Object)new StringTablesPair("1")));
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("2");
                this.will(7.returnValue((Object)new StringTablesPair("2")));
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter("a", "1");
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter("b", "2");
            }
        });
        this.formals.add("a");
        this.formals.add("b");
        this.binder.bindUni(this.actuals("1", "2"), this.resolver);
    }

    @Test
    public void bindUniWorksWithNestedTable() {
        final Tables tables = TableFactory.tables(TableFactory.table(TableFactory.row("x")));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DynamicVariables)this.allowing(TestParameterBinder.this.resolver)).resolve("x");
                this.will(8.returnValue((Object)new StringTablesPair("x")));
                ((DynamicVariables)this.one(TestParameterBinder.this.resolver)).putParameter((String)this.with("a"), this.with((Matcher)new TablesMatcher(tables, TestParameterBinder.this.resolver)));
            }
        });
        this.formals.add("a");
        this.binder.bindUni(this.actuals(tables), this.resolver);
    }

    private List<Object> actuals(Object ... objectArray) {
        return CollectionUtility.list(objectArray);
    }
}

