/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.dynamicVariable;

import fit.Fixture;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class DynamicVariablesMap
implements DynamicVariables {
    private Map<Object, Object> map = new HashMap<Object, Object>(System.getProperties());

    public DynamicVariablesMap() {
    }

    public DynamicVariablesMap(DynamicVariables dynamicVariables) {
        this.map = new HashMap<Object, Object>(dynamicVariables.getMap());
    }

    @Override
    public Pair<String, Tables> resolve(String locator) {
        String result = locator;
        Tables tables = TableFactory.tables();
        int pos = 0;
        int loops = 0;
        while ((pos = result.indexOf("@{", pos)) >= 0) {
            if (loops++ > 10000) {
                return new Pair<String, Tables>("INFINITE SUBSTITUTION!", tables);
            }
            int end = result.indexOf("}", pos);
            if (end < 0) continue;
            Object substitute = this.get(result.substring(pos + 2, end));
            if (substitute != null) {
                boolean isTables = substitute instanceof Tables;
                String replace = isTables ? "" : Fixture.escape(substitute.toString());
                result = result.substring(0, pos) + replace + result.substring(end + 1);
                if (isTables) {
                    tables.addTables((Tables)substitute);
                }
                pos = 0;
                continue;
            }
            pos += 2;
        }
        return new Pair<String, Tables>(result, tables);
    }

    @Override
    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public void putAll(Properties properties) {
        this.map.putAll(properties);
    }

    @Override
    public void clearAll() {
        this.map.clear();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public String getAsString(String key) {
        Object result = this.get(key);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    @Override
    public Map<Object, Object> getMap() {
        return new HashMap<Object, Object>(this.map);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(this.map.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Object key : keys) {
            s.append(key);
            s.append(" = ");
            s.append(this.map.get(key));
            s.append("<br/>");
        }
        return s.toString();
    }
}

