/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.eg;

import fitlibrary.eg.DomainAdapterWithVariables;
import fitlibrary.eg.Variable;
import java.util.ArrayList;
import java.util.List;

public class AccountVariables
extends DomainAdapterWithVariables {
    private AccountsRepository accountsRepository = new AccountsRepository();

    @Override
    public Object getSystemUnderTest() {
        return null;
    }

    public boolean createAccountNamedWithId(String accountName, Variable idVariable) {
        idVariable.setValue(this.accountsRepository.create(accountName));
        return true;
    }

    public boolean addToAccount(float amount, Variable idVariable) {
        this.account(idVariable).add(amount);
        return true;
    }

    public Account account(Variable idVariable) {
        return this.accountsRepository.getAccount((Integer)idVariable.getValue());
    }

    public static class Account {
        private int id;
        private String name;
        private float balance;

        public Account(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void add(float balance2) {
            this.balance += balance2;
        }
    }

    public static class AccountsRepository {
        private static int NEXT_ID = 0;
        public List<Account> accounts = new ArrayList<Account>();

        public List<Account> getAccounts() {
            return this.accounts;
        }

        public Account getAccount(int id) {
            for (Account account : this.accounts) {
                if (account.getId() != id) continue;
                return account;
            }
            return null;
        }

        public Integer create(String accountName) {
            this.accounts.add(new Account(++NEXT_ID, accountName));
            return NEXT_ID;
        }

        public void setAccounts(List<Account> accounts) {
            this.accounts = accounts;
        }
    }
}

