/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.config.Configuration;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.flow.DoFlowOnTable;
import fitlibrary.flow.IScopeStack;
import fitlibrary.flow.SetUpTearDown;
import fitlibrary.flow.TestDoFlowOnTableWithFixture;
import fitlibrary.object.DomainFixtured;
import fitlibrary.runResults.ITableListener;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.FitHandler;
import fitlibrary.traverse.workflow.FlowEvaluator;
import fitlibraryGeneric.typed.GenericTypedObject;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.States;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.StatePredicate;

public class DoFlowOnTableDriver {
    private final Mockery context;
    final FlowEvaluator flowEvaluator;
    final IScopeStack scopeStack;
    final ITableListener tableListener;
    final SetUpTearDown setUpTearDown;
    final RuntimeContextInternal runtime;
    final DoFlowOnTable.DoFlower doFlower;
    final TestResults testResults;
    final DoFlowOnTable doFlowOnTable;
    final Configuration config;
    final VariableResolver resolver = new GlobalDynamicVariables();
    final States state;
    static final String BEGIN_STATE = "begin";
    String currentState = "begin";
    int rowNo = 0;

    public DoFlowOnTableDriver(Mockery mockery) {
        this.context = mockery;
        this.flowEvaluator = (FlowEvaluator)mockery.mock(FlowEvaluator.class);
        this.scopeStack = (IScopeStack)mockery.mock(IScopeStack.class);
        this.tableListener = (ITableListener)mockery.mock(ITableListener.class);
        this.setUpTearDown = (SetUpTearDown)mockery.mock(SetUpTearDown.class);
        this.runtime = (RuntimeContextInternal)mockery.mock(RuntimeContextInternal.class, "runtime");
        this.doFlower = (DoFlowOnTable.DoFlower)mockery.mock(DoFlowOnTable.DoFlower.class);
        this.config = (Configuration)mockery.mock(Configuration.class);
        this.testResults = TestResultsFactory.testResults();
        this.doFlowOnTable = new DoFlowOnTable(this.flowEvaluator, this.scopeStack, this.setUpTearDown, this.doFlower);
        this.state = mockery.states("doFlowOnTable").startsAs(BEGIN_STATE);
        this.startTable();
    }

    public void runTable(Table table) {
        this.poppingScopeStackAtEndOfTable();
        this.doFlowOnTable.runTable(table, this.testResults, this.runtime);
    }

    public void startingOnTable(final Table table) {
        final String string = this.endState("startingOnTable");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(DoFlowOnTableDriver.this.runtime)).setCurrentTable(table);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((ITableListener)this.allowing(DoFlowOnTableDriver.this.tableListener)).getTestResults();
                this.will(1.returnValue((Object)DoFlowOnTableDriver.this.testResults));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((RuntimeContextInternal)this.oneOf(DoFlowOnTableDriver.this.runtime)).pushTestResults((TestResults)this.with(1.any(TestResults.class)));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void startingOnRow() {
        ++this.rowNo;
        final String string = this.endState("startingOnRow");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).isAbandoned((TestResults)this.with(2.any(TestResults.class)));
                this.will(2.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((DoFlowOnTable.DoFlower)this.allowing(DoFlowOnTableDriver.this.doFlower)).hasDomainCheck();
                this.will(2.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void startingOnRowWithDomainCheck() {
        ++this.rowNo;
        final String string = this.endState("startingOnRow");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).isAbandoned((TestResults)this.with(3.any(TestResults.class)));
                this.will(3.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((DoFlowOnTable.DoFlower)this.allowing(DoFlowOnTableDriver.this.doFlower)).hasDomainCheck();
                this.will(3.returnValue((Object)true));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void interpretingRowReturning(final Row row, final Object object) {
        final String string = this.endState("interpretingRowReturning");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).isAbandoned((TestResults)this.with(4.any(TestResults.class)));
                this.will(4.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((DoFlowOnTable.DoFlower)this.allowing(DoFlowOnTableDriver.this.doFlower)).hasDomainCheck();
                this.will(4.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((RuntimeContextInternal)this.oneOf(DoFlowOnTableDriver.this.runtime)).setCurrentRow(row);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((FlowEvaluator)this.oneOf(DoFlowOnTableDriver.this.flowEvaluator)).interpretRow(row, DoFlowOnTableDriver.this.testResults);
                this.will(4.returnValue((Object)new GenericTypedObject(object)));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void interpretingFixture(final TestDoFlowOnTableWithFixture.MockFixture mockFixture, final Table table) throws FitParseException {
        final Parse parse = new Parse("<table><tr><td>1</td></tr></table>");
        final String string = this.endState("interpretingFixture");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(table)).asTableOnParse();
                this.will(5.returnValue((Object)table));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((FlowEvaluator)this.oneOf(DoFlowOnTableDriver.this.flowEvaluator)).fitHandler();
                this.will(5.returnValue((Object)new FitHandler()));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((Table)this.oneOf(table)).asParse();
                this.will(5.returnValue((Object)parse));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((TestDoFlowOnTableWithFixture.MockFixture)this.oneOf(mockFixture)).doTable(parse);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((Table)this.oneOf(table)).replaceAt(0, (Row)table.at(0));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((Table)this.oneOf(table)).replaceAt(1, (Row)table.at(1));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    private void poppingScopeStackAtEndOfTable() {
        final String string = this.endState("poppingScopeStackAtEndOfTable");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.oneOf(DoFlowOnTableDriver.this.runtime)).popTestResults();
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void pushingObjectOnScopeStack(final Object object) {
        final String string = this.endState("pushingObjectOnScopeStack");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((IScopeStack)this.oneOf(DoFlowOnTableDriver.this.scopeStack)).push(new GenericTypedObject(object));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSetUpOn(final Object object, final Row row) {
        final String string = this.endState("callingSetUpOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowOnTableDriver.this.setUpTearDown)).callSetUpOnSutChain(object, row, DoFlowOnTableDriver.this.testResults);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void interpretingEvaluator(final Evaluator evaluator, final Table table) {
        final String string = this.endState("interpretingEvaluator");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Evaluator)this.oneOf(evaluator)).interpretAfterFirstRow(table, DoFlowOnTableDriver.this.testResults);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void runInnerTables(final Tables tables) {
        final String string = this.endState("runInnerTables");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).isAbandoned((TestResults)this.with(10.any(TestResults.class)));
                this.will(10.returnValue((Object)false));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                ((DoFlowOnTable.DoFlower)this.oneOf(DoFlowOnTableDriver.this.doFlower)).runInnerTables(tables, DoFlowOnTableDriver.this.testResults);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    private void startTable() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ITableListener)this.allowing(DoFlowOnTableDriver.this.tableListener)).getTestResults();
                this.will(11.returnValue((Object)DoFlowOnTableDriver.this.testResults));
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).getResolver();
                this.will(11.returnValue((Object)DoFlowOnTableDriver.this.resolver));
                ((RuntimeContextInternal)this.allowing(DoFlowOnTableDriver.this.runtime)).getConfiguration();
                this.will(11.returnValue((Object)DoFlowOnTableDriver.this.config));
                ((Configuration)this.allowing(DoFlowOnTableDriver.this.config)).isAddTimings();
                this.will(11.returnValue((Object)false));
            }
        });
    }

    private String endState(String string) {
        return string + "." + this.rowNo;
    }

    public RuntimeContextInternal getRuntime() {
        return this.runtime;
    }

    public void setSuite(final SuiteEvaluator suiteEvaluator) {
        final String string = this.endState("setSuite");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoFlowOnTable.DoFlower)this.oneOf(DoFlowOnTableDriver.this.doFlower)).setSuite(suiteEvaluator);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSuiteSetUpOn(final Object object, final Row row) {
        final String string = this.endState("callingSuiteSetUpOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowOnTableDriver.this.setUpTearDown)).callSuiteSetUp(object, row, DoFlowOnTableDriver.this.testResults);
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void callingSuiteTearDownOn(final Object object) {
        final String string = this.endState("callingSuiteTearDownOn");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SetUpTearDown)this.oneOf(DoFlowOnTableDriver.this.setUpTearDown)).callSuiteTearDown(this.with(object), (TestResults)this.with(14.any(TestResults.class)));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void settingDomainToCheck() {
        final String string = this.endState("settingDomainToCheck");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoFlowOnTable.DoFlower)this.oneOf(DoFlowOnTableDriver.this.doFlower)).setDomainToCheck();
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }

    public void settingDomainFixture(final DomainFixtured domainFixtured) {
        final String string = this.endState("settingDomainFixture");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoFlowOnTable.DoFlower)this.oneOf(DoFlowOnTableDriver.this.doFlower)).setDomainFixture(new GenericTypedObject(domainFixtured));
                this.when((StatePredicate)DoFlowOnTableDriver.this.state.is(DoFlowOnTableDriver.this.currentState));
                this.then(DoFlowOnTableDriver.this.state.is(string));
            }
        });
        this.currentState = string;
    }
}

