/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow;

import fit.ColumnFixture;
import fitlibrary.DoFixture;
import fitlibrary.collection.array.ArrayTraverse;
import fitlibrary.collection.list.ListTraverse;
import fitlibrary.collection.map.MapTraverse;
import fitlibrary.collection.set.SetTraverse;
import fitlibrary.flow.DoAutoWrapper;
import fitlibrary.flow.IDoAutoWrapper;
import fitlibrary.object.DomainFixtured;
import fitlibrary.parser.ParserTestCase;
import fitlibrary.traverse.workflow.DoTraverse;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestDoAutoWrapper {
    DoFixture doFixture = ParserTestCase.evaluatorWithRuntime();
    DoTraverse doTraverse = ParserTestCase.evaluatorWithRuntime(new DoTraverse());
    IDoAutoWrapper autoWrapper = new DoAutoWrapper(this.doFixture);

    @Test
    public void nullValueInTypedResultIsNotAutoWrappedButReturnsAsNull() {
        this.verify(null, null);
    }

    @Test
    public void stringIsNotAutoWrapped() {
        this.verify("a", "a");
    }

    @Test
    public void stringBufferIsNotAutoWrapped() {
        StringBuffer stringBuffer = new StringBuffer("a");
        this.verify(stringBuffer, stringBuffer);
    }

    @Test
    public void primitiveLikeIsNotAutoWrapped() {
        this.verify(Character.valueOf('a'), Character.valueOf('a'));
        this.verify(true, true);
        this.verify(1L, 1L);
        this.verify(1, 1);
        this.verify(1.2, 1.2);
        this.verify(Float.valueOf(1.2f), Float.valueOf(1.2f));
        this.verify(new BigDecimal(1.1), new BigDecimal(1.1));
        this.verify(new BigInteger("1"), new BigInteger("1"));
    }

    @Test
    public void fitFixtureIsNotAutoWrapped() {
        ColumnFixture columnFixture = new ColumnFixture();
        this.verify(columnFixture, columnFixture);
    }

    @Test
    public void sameDoFixtureIsNotAutoWrapped() {
        this.verify(this.doFixture, this.doFixture);
    }

    @Test
    public void doTraverseIsNotAutoWrappedButHasOuterContextSet() {
        this.verify(this.doTraverse, this.doTraverse);
    }

    @Test
    public void objectWithParseMethodIsNotAutoWrapped() {
        WithParse withParse = new WithParse();
        this.verify(withParse, withParse);
    }

    @Test
    public void domainFixturedIsNotAutoWrapped() {
        DomainFixtured domainFixtured = new DomainFixtured(){};
        this.verify(domainFixtured, domainFixtured);
    }

    @Test
    public void mapIsAutoWrappedWithMapTraverse() {
        this.verifyClass(new HashMap(), MapTraverse.class);
    }

    @Test
    public void arrayIsAutoWrappedWithArrayTraverse() {
        this.verifyClass(new String[]{"a"}, ArrayTraverse.class);
    }

    @Test
    public void setIsAutoWrappedWithArrayTraverse() {
        this.verifyClass(new HashSet(), SetTraverse.class);
    }

    @Test
    public void listIsAutoWrappedWithArrayTraverse() {
        this.verifyClass(new ArrayList(), ListTraverse.class);
    }

    @Test
    public void otherIsAutoWrappedWithDoTraverse() {
        this.verifyClass(new WithOutParse(), DoTraverse.class);
    }

    private void verify(Object object, Object object2) {
        MatcherAssert.assertThat((Object)this.autoWrapper.wrap(new GenericTypedObject(object)), (Matcher)CoreMatchers.is((Object)new GenericTypedObject(object2)));
    }

    private void verifyClass(Object object, Class<?> clazz) {
        TypedObject typedObject = this.autoWrapper.wrap(new GenericTypedObject(object));
        MatcherAssert.assertThat((Object)typedObject.getSubject(), (Matcher)CoreMatchers.instanceOf(clazz));
    }

    static class WithOutParse {
        WithOutParse() {
        }
    }

    static class WithParse {
        WithParse() {
        }

        public static Object parse(String string) {
            return string;
        }
    }
}

