/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.flow.actor;

import fitlibrary.flow.DoFlow;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.suite.Reporter;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class DoFlowActor
implements Runnable {
    public static Logger logger = FitLibraryLogger.getLogger(DoFlowActor.class);
    private final BlockingQueue<FlowAction> queue = new LinkedBlockingQueue<FlowAction>();
    protected final DoFlow doFlow;
    protected final Queue<Reporter.ReportAction> reportQueue;
    protected final TestResults testResults;

    public DoFlowActor(DoFlow doFlow, Queue<Reporter.ReportAction> reportQueue, TestResults testResults) {
        this.doFlow = doFlow;
        this.reportQueue = reportQueue;
        this.testResults = testResults;
    }

    public void addTable(Table table) {
        this.queue.add(new TableAction(table));
    }

    public void endStorytest() {
        this.queue.add(new EndStoryTestAction());
    }

    @Override
    public void run() {
        logger.trace((Object)"Running storytest");
        this.doFlow.resetToStartStorytest();
        try {
            FlowAction action;
            do {
                action = this.queue.take();
                action.run();
            } while (!action.isDone());
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    class EndStoryTestAction
    implements FlowAction {
        EndStoryTestAction() {
        }

        @Override
        public void run() {
            Table errorTable = TableFactory.table(TableFactory.row("<i>Error in storytest tear down: </i>"));
            DoFlowActor.this.doFlow.finishLastTable(errorTable, DoFlowActor.this.testResults);
            DoFlowActor.this.doFlow.addAccumulatedFoldingText(errorTable);
            if (errorTable.size() > 1 || ((Row)errorTable.at(0)).size() > 1 || ((Cell)((Row)errorTable.at(0)).at(0)).hadError() || !errorTable.getTrailer().isEmpty()) {
                errorTable.setLeader("\n<br/>");
                DoFlowActor.this.reportQueue.add(new Reporter.TableReport(errorTable));
            }
            logger.trace((Object)"Finished storytest");
            DoFlowActor.this.reportQueue.add(new Reporter.ReportFinished());
            DoFlowActor.this.doFlow.exit();
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    class TableAction
    implements FlowAction {
        private final Table table;

        public TableAction(Table table) {
            this.table = table;
        }

        @Override
        public void run() {
            DoFlowActor.this.doFlow.runSingleTable(DoFlowActor.this.testResults, this.table);
            DoFlowActor.this.doFlow.finishTable(this.table, DoFlowActor.this.testResults);
            DoFlowActor.this.doFlow.addAccumulatedFoldingText(this.table);
            DoFlowActor.this.reportQueue.add(new Reporter.TableReport(this.table));
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }

    static interface FlowAction {
        public void run();

        public boolean isDone();
    }
}

