/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.matcher;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.spec.TablesCompare;
import fitlibrary.table.Tables;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class TablesMatcher
extends TypeSafeMatcher<Tables> {
    private final Tables expectedTables;
    private final VariableResolver resolver;

    public TablesMatcher(Tables expected, VariableResolver resolver) {
        this.expectedTables = expected;
        this.resolver = resolver;
    }

    public boolean matchesSafely(Tables actualTables) {
        SpecifyErrorReport specifyErrorReport = new SpecifyErrorReport(){

            @Override
            public void actualResult(Tables actualResult) {
                System.out.println("actualResult " + actualResult.toString());
            }

            @Override
            public void cellTextWrong(String path, String actual, String expected) {
                this.display("cellTextWrong", path, actual, expected);
            }

            @Override
            public void leaderWrong(String path, String actual, String expected) {
                this.display("leaderWrong", path, actual, expected);
            }

            @Override
            public void sizeWrong(String path, int actual, int expected) {
                System.out.println("sizeWrong at " + path + " Actual: " + actual + " Expected: " + expected);
            }

            @Override
            public void tagLineWrong(String path, String actual, String expected) {
                this.display("tagLineWrong", path, actual, expected);
            }

            @Override
            public void trailerWrong(String path, String actual, String expected) {
                this.display("trailerWrong", path, actual, expected);
            }

            private void display(String action, String path, String actualText, String expectedText) {
                System.out.println(action + " at " + path + "\nActual:----\n" + actualText + "\nExpected:----\n" + expectedText + "\n----");
            }
        };
        return new TablesCompare(specifyErrorReport, this.resolver).tablesEqual("tables", actualTables, this.expectedTables);
    }

    public void describeTo(Description description) {
        description.appendText("a table the same as ").appendValue((Object)this.expectedTables);
    }
}

