/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.object;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.NoSystemUnderTestException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.global.PlugBoard;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.object.DomainTraverser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedObject;

public class DomainCheckTraverse
extends Traverse
implements TableEvaluator {
    private DomainTraverser domainTraverser;

    public DomainCheckTraverse() {
    }

    public DomainCheckTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        table.error(testResults, (Throwable)new RuntimeException("Don't expect to have this called!"));
        return null;
    }

    public void setDomainTraverse(DomainTraverser domainTraverser) {
        this.domainTraverser = domainTraverser;
    }

    @Override
    public void runTable(Table table, TestResults testResults) {
        if (this.switchOnExpected(table)) {
            this.domainTraverser.setCurrentAction();
            return;
        }
        try {
            for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                Row row = (Row)table.at(rowNo);
                if (row.text(0, this).equals("comment")) {
                    return;
                }
                this.processRow(row, testResults);
            }
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    private void processRow(Row row, TestResults testResults) {
        for (int i = 0; i < row.size(); i += 2) {
            Cell cell = (Cell)row.at(i);
            Cell cell2 = (Cell)row.at(i + 1);
            if (DomainObjectSetUpTraverse.givesClass(cell, this)) {
                if (this.getSystemUnderTest() == null) {
                    throw new NoSystemUnderTestException();
                }
                this.checkClass(testResults, cell, cell2);
                continue;
            }
            try {
                ICalledMethodTarget target = PlugBoard.lookupTarget.findGetterOnSut(cell.text(this), this, "Type");
                target.invokeAndCheck(TableFactory.row(), cell2, testResults, false);
                continue;
            }
            catch (MissingMethodException ex) {
                cell.error(testResults, ex);
            }
        }
    }

    private void checkClass(TestResults testResults, Cell cell, Cell classCell) {
        String typeName = classCell.text(this);
        try {
            Class<?> sutClass = PlugBoard.lookupTarget.findClassFromFactoryMethod(this, this.getTypedSystemUnderTest().classType(), typeName);
            if (this.getSystemUnderTest().getClass().equals(sutClass)) {
                classCell.pass(testResults);
            } else {
                classCell.fail(testResults);
            }
        }
        catch (Exception e) {
            cell.error(testResults, e);
        }
    }

    private boolean switchOnExpected(Table table) {
        return this.domainTraverser != null && table.size() == 1 && ((Row)table.at(0)).size() == 1 && ((Cell)((Row)table.at(0)).at(0)).matchesTextInLowerCase("expected", this);
    }

    @Override
    public void addNamedObject(String text, TypedObject typedObject, Row row, TestResults testResults) {
    }

    @Override
    public void select(String name) {
    }

    @Override
    public void runInnerTables(Tables definedActionBody, TestResults testResults) {
    }
}

