/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.lookup;

import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.object.DomainObjectCheckTraverse;
import fitlibrary.object.DomainObjectSetUpTraverse;
import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import java.beans.PropertyEditor;

public class PropertyEditorBasedParser
implements Parser {
    private PropertyEditor editor;
    private Evaluator evaluator;
    private Typed typed;
    private boolean nullOK;

    public PropertyEditorBasedParser(Evaluator evaluator, Typed typed, PropertyEditor editor, boolean nullOK) {
        this.evaluator = evaluator;
        this.typed = typed;
        this.editor = editor;
        this.nullOK = nullOK;
    }

    @Override
    public TypedObject parseTyped(Cell cell, TestResults testResults) throws Exception {
        return this.typed.typedObject(this.parse(cell, testResults));
    }

    private Object parse(Cell cell, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTables(this.evaluator)) {
            return this.parseTable(cell.getEmbeddedTable(), testResults);
        }
        if (this.nullOK && cell.isBlank(this.evaluator)) {
            return null;
        }
        try {
            return this.parse(cell.text(this.evaluator));
        }
        catch (NumberFormatException e) {
            throw new BadNumberException();
        }
    }

    private Object parse(String text) throws Exception {
        this.editor.setAsText(text);
        return this.editor.getValue();
    }

    private Object parseTable(Table embeddedTable, TestResults testResults) throws Exception {
        Object newInstance = this.typed.newInstance();
        DomainObjectSetUpTraverse setUp = new DomainObjectSetUpTraverse(newInstance);
        setUp.setRuntimeContext(this.evaluator.getRuntimeContext());
        setUp.callStartCreatingObjectMethod(newInstance);
        setUp.interpretInnerTableWithInScope(embeddedTable, this.evaluator.getRuntimeContext(), testResults);
        setUp.callEndCreatingObjectMethod(newInstance);
        return newInstance;
    }

    @Override
    public boolean matches(Cell cell, Object result, TestResults testResults) throws Exception {
        if (cell.hasEmbeddedTables(this.evaluator)) {
            return this.matchesTable(cell.getEmbeddedTable(), result, testResults);
        }
        return this.matches(this.parse(cell, testResults), result);
    }

    private boolean matches(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private boolean matchesTable(Table table, Object result, TestResults testResults) {
        DomainObjectCheckTraverse traverse = new DomainObjectCheckTraverse(result, this.typed);
        return traverse.doesInnerTablePass(table, this.evaluator.getRuntimeContext(), testResults);
    }

    @Override
    public String show(Object object) {
        this.editor.setValue(object);
        return this.editor.getAsText();
    }

    public String toString() {
        return "PropertyEditorBasedParser[" + this.editor + "]";
    }

    @Override
    public Evaluator traverse(TypedObject typedObject) {
        throw new RuntimeException("No Traverse available");
    }
}

