/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.table;

import fit.Parse;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.exception.table.MissingTableException;
import fitlibrary.parser.HtmlStructureParser;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.parser.table.Table;
import fitlibrary.parser.table.TableInterface;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;

public class TableParser
extends HtmlStructureParser {
    public TableParser(Typed typed) {
        super(typed);
    }

    public static boolean applicableType(Class<?> type) {
        return TableInterface.class.isAssignableFrom(type);
    }

    @Override
    protected Object parse(Cell cell, TestResults testResults) throws Exception {
        if (!cell.hasEmbeddedTables(new GlobalDynamicVariables())) {
            throw new MissingTableException();
        }
        Parse parse = cell.getEmbeddedTable().asParse();
        Object[] args = new Object[]{parse};
        Class[] argTypes = new Class[]{Parse.class};
        return this.callReflectively("parseTable", args, argTypes, null);
    }

    @Override
    public String show(Object object) {
        if (object == null) {
            return "null";
        }
        return this.callReflectively("toTable", new Object[0], new Class[0], object).toString();
    }

    @Override
    protected boolean areEqual(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Table.equals(expected, actual);
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            @Override
            public Parser parser(Evaluator evaluator, Typed typed) {
                return new TableParser(typed);
            }
        };
    }

    @Override
    public Evaluator traverse(TypedObject typedObject) {
        throw new RuntimeException("No Traverse available");
    }
}

