/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parser.tree;

import fitlibrary.parser.tree.ListTree;
import fitlibrary.parser.tree.Tree;
import junit.framework.TestCase;

public class TestListTree
extends TestCase {
    private Tree topTree;
    private Tree tree;
    private Tree toplessTree;

    public void setUp() {
        this.topTree = new ListTree("top");
        this.tree = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("c")})});
        this.toplessTree = new ListTree("", new Tree[]{new ListTree("a"), new ListTree("b")});
    }

    public void testEqualsSameOne() {
        this.treesEqual(this.topTree, this.topTree);
    }

    public void testEqualsSimilarOne() {
        this.treesEqual(this.topTree, new ListTree("top"));
    }

    public void testNotEqualsSimilarOne() {
        this.treesUnEqual(this.topTree, new ListTree("bottom"));
    }

    public void testTopToString() {
        TestListTree.assertEquals((String)"top", (String)this.topTree.toString());
    }

    public void testToplessTreeToString() {
        TestListTree.assertEquals((String)"<ul><li>a</li><li>b</li></ul>", (String)this.toplessTree.toString());
    }

    public void testEqualsSameTree() {
        this.treesEqual(this.tree, this.tree);
    }

    public void testEqualsSimilarTree() {
        ListTree listTree = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("c")})});
        this.treesEqual(this.tree, listTree);
    }

    public void testNotEqualsTop() {
        this.treesUnEqual(this.tree, this.topTree);
        this.treesUnEqual(this.topTree, this.toplessTree);
    }

    public void testNotEqualsSimilarShapedTree() {
        ListTree listTree = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("C")})});
        this.treesUnEqual(this.tree, listTree);
    }

    public void testNotEqualsDifferentShapedTree() {
        ListTree listTree = new ListTree("tree", new Tree[]{new ListTree("a", new Tree[]{new ListTree("c")}), new ListTree("b")});
        this.treesUnEqual(this.tree, listTree);
        this.treesUnEqual(this.tree, this.toplessTree);
    }

    public void testTreeToString() {
        TestListTree.assertEquals((String)"tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>", (String)this.tree.toString());
    }

    public void testParseTop() {
        TestListTree.assertEquals((Object)this.topTree, (Object)ListTree.parse("top"));
    }

    public void testParseTree1() {
        TestListTree.assertEquals((String)"tree<ul><li>a</li></ul>", (String)ListTree.parse("tree<ul><li>a</li></ul>").toString());
    }

    public void testParseTree() {
        this.assertParsed("tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseTreeWithblanks() {
        this.assertParsed("tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseToplessTree() {
        this.assertParsed("<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseTags0() {
        this.assertParsed("<i>a</i>");
    }

    public void testParseSpace() {
        TestListTree.assertEquals((String)"a", (String)ListTree.parse("<i>a  </i>").text());
    }

    public void testParseTags1() {
        this.assertParsed("tree<ul><li><i>a</i></li></ul>");
    }

    public void testParseTags2() {
        this.assertParsed("tree<ul><li>a<i>b</i><b>c</b></li></ul>");
    }

    public void testEqualsIgnoringWhiteSpace() {
        this.treesEqual("tree<ul>\r\t\t  <li>a</li> \n<li>b<ul>   </ul>\n  </li>\n\t\n</ul>", "tree<ul><li>a</li><li>b<ul></ul></li></ul>");
    }

    public void testEqualsIgnoringWhiteSpaceInBoth() {
        this.treesEqual("tree<ul>\r\t\t  <li>a</li> \n<li>b<ul>   </ul>\n  </li>\n\t\n</ul>", "tree<ul> <li>a</li>\n\n<li>b<ul>\r\n</ul>\n\n\n</li></ul>");
    }

    public void testEqualsSimilarWithTags() {
        this.treesEqual(this.topTree, new ListTree("<i>top</i>"));
    }

    public void testTopText() {
        TestListTree.assertEquals((String)"top", (String)new ListTree("top").text());
    }

    public void testToplessTreeText() {
        TestListTree.assertEquals((String)"<ul><li>a</li><li>b</li></ul>", (String)this.toplessTree.text());
    }

    public void testTopTextWithTags() {
        TestListTree.assertEquals((String)"top", (String)new ListTree("<i><b>top</b></i>").text());
    }

    public void testTreeText() {
        TestListTree.assertEquals((String)"tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>", (String)this.tree.text());
    }

    public void testTreeTextWithTags() {
        String string = "tree<ul><li>a<i>b</i><b>c</b></li></ul>";
        TestListTree.assertEquals((String)"tree<ul><li>abc</li></ul>", (String)ListTree.parse(string).text());
    }

    public void testParseTreeNoCloseLi() {
        try {
            ListTree.parse("tree<ul><li>a<li>b<ul><li>c</ul></ul>");
            TestListTree.fail((String)"Doesn't handle lists with </li> missing.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void assertParsed(String string) {
        TestListTree.assertEquals((String)string, (String)ListTree.parse(string).toString());
    }

    private void treesEqual(String string, String string2) {
        this.treesEqual(ListTree.parse(string), ListTree.parse(string2));
    }

    private void treesEqual(Tree tree, Tree tree2) {
        TestListTree.assertTrue((boolean)tree.equals(tree2));
        TestListTree.assertTrue((boolean)tree2.equals(tree));
        TestListTree.assertTrue((boolean)ListTree.equals(tree, tree2));
        TestListTree.assertTrue((boolean)ListTree.equals(tree2, tree));
    }

    private void treesUnEqual(Tree tree, Tree tree2) {
        TestListTree.assertFalse((boolean)tree.equals(tree2));
        TestListTree.assertFalse((boolean)tree2.equals(tree));
        TestListTree.assertFalse((boolean)ListTree.equals(tree, tree2));
        TestListTree.assertFalse((boolean)ListTree.equals(tree2, tree));
    }
}

