/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.polling;

import fitlibrary.log.FitLibraryLogger;
import fitlibrary.polling.PassFail;
import fitlibrary.polling.PollForPass;
import org.apache.log4j.Logger;

public class Eventually {
    private static Logger logger = FitLibraryLogger.getLogger(Eventually.class);
    protected static final long MIN_SLEEP = 2L;
    protected static final long MAX_SLEEP = 10L;
    protected static final long DIV_SLEEP = 50L;
    private final long timeout;
    private long start = Eventually.now();
    private final long sleepPeriod;

    public Eventually(long timeout) {
        this.timeout = timeout;
        this.sleepPeriod = Math.min(10L, Math.max(2L, timeout / 50L));
    }

    public PassFail poll(PollForPass poll) throws Exception {
        PassFail answer = new PassFail(false, null);
        this.start = Eventually.now();
        while (true) {
            answer = poll.result();
            if (answer.hasPassed) {
                if (this.delay() > 0L) {
                    logger.trace((Object)("Passed after " + this.delay() + " milliseconds"));
                }
                return answer;
            }
            if (this.timedOut()) break;
            this.sleep();
        }
        logger.trace((Object)("Failed after " + this.delay() + " milliseconds"));
        return answer;
    }

    private boolean timedOut() {
        return this.delay() > this.timeout;
    }

    private long delay() {
        return Eventually.now() - this.start;
    }

    private void sleep() {
        try {
            Thread.sleep(this.sleepPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }
}

