/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitProtocol;
import fit.FitServerBridge;
import fit.exception.FitParseException;
import fitlibrary.flow.actor.DoFlowActor;
import fitlibrary.log.ConfigureLoggingThroughFiles;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsOnCounts;
import fitlibrary.suite.BatchFitLibrarySingleStep;
import fitlibrary.suite.FitLibraryServer;
import fitlibrary.suite.Reporter;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class FitLibraryServerSingleStep
extends FitServerBridge {
    static Logger logger = FitLibraryLogger.getLogger(FitLibraryServer.class);
    private BatchFitLibrarySingleStep batching = new BatchFitLibrarySingleStep();
    private final BlockingQueue<Reporter.ReportAction> reportQueue = new LinkedBlockingQueue<Reporter.ReportAction>();
    private final DoFlowActor actor = this.batching.actor(this.reportQueue, this.suiteTestResults);
    private final CountDownLatch endGate = new CountDownLatch(1);

    @Override
    public TestResults doTables(String html) {
        try {
            return this.doTables(TableFactory.tables(html));
        }
        catch (FitParseException e) {
            e.printStackTrace();
            return new TestResultsOnCounts();
        }
    }

    public TestResults doTables(Tables tables) {
        for (int t = 0; t < tables.size(); ++t) {
            this.actor.addTable((Table)tables.at(t));
        }
        return this.suiteTestResults;
    }

    @Override
    public void exit() throws Exception {
        this.batching.exit();
        super.exit();
    }

    @Override
    protected void usage() {
        logger.trace((Object)"usage: java fitlibrary.suite.FitLibraryServerSingleStep [-v] host port socketTicket");
        System.exit(-1);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() {
        FitLibraryServerSingleStep.logger.trace((Object)"Ready to receive tables from ZiBreve");
        new Thread(new Reporter(this.reportQueue, this, this.endGate, this.suiteTestResults)).start();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                FitLibraryServerSingleStep.logger.trace((Object)"Reading table size...");
                size = FitProtocol.readSize(this.socketReader);
                if (size == 0) {
                    FitLibraryServerSingleStep.logger.trace((Object)"No more tables to receive from ZiBreve");
                    this.actor.endStorytest();
                    this.endGate.await();
                    return;
                }
                FitLibraryServerSingleStep.logger.trace((Object)("Received table of size " + size + " from ZiBreve"));
                try {
                    document = FitProtocol.readDocument(this.socketReader, size);
                    this.doTables(document);
                    FitLibraryServerSingleStep.logger.trace((Object)"Finished running table");
                }
                catch (FitParseException e) {
                    this.exception(e);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.exception(e);
        }
        ** GOTO lbl-1000
    }

    public static void main(String[] args) {
        ConfigureLoggingThroughFiles.configure();
        FitLibraryServerSingleStep fitServer = new FitLibraryServerSingleStep();
        try {
            logger.trace((Object)new Date());
            fitServer.run(args);
            logger.trace((Object)("Exit: " + fitServer.exitCode()));
            if (fitServer.isExit()) {
                System.exit(fitServer.exitCode());
            }
        }
        catch (Exception e) {
            fitServer.printExceptionDetails(e);
        }
    }
}

