/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.function;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.method.BooleanMethodException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.global.PlugBoard;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.function.FunctionTraverse;

public class ConstraintTraverse
extends FunctionTraverse {
    private ICalledMethodTarget target;
    private boolean expected = true;
    protected boolean methodOK = false;
    protected int argCount = -1;
    protected boolean boundOK = false;

    public ConstraintTraverse() {
    }

    public ConstraintTraverse(Object sut, boolean expected) {
        super(sut);
        this.setExpected(expected);
    }

    public ConstraintTraverse(Object sut) {
        super(sut);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.bindFirstRowToTarget((Row)table.at(1), testResults);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow((Row)table.at(i), testResults);
        }
        return null;
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults) {
        this.argCount = row.size();
        String argNames = "";
        for (int i = 0; i < this.argCount; ++i) {
            argNames = argNames + row.text(i, this) + " ";
        }
        try {
            this.target = PlugBoard.lookupTarget.findTheMethodMapped(argNames, this.argCount, this);
            if (!this.target.returnsBoolean()) {
                throw new BooleanMethodException(this.extendedCamel(argNames));
            }
            this.target.setRepeatAndExceptionString(this.repeatString, this.exceptionString);
            this.methodOK = true;
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            if (this.expected) {
                row.error(testResults, e);
            }
            row.pass(testResults);
        }
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.methodOK) {
            row.ignore(testResults);
            return;
        }
        if (row.size() != this.argCount) {
            row.error(testResults, new RowWrongWidthException(this.argCount));
            return;
        }
        try {
            boolean result = (Boolean)this.target.invoke(row, testResults, true);
            if (result == this.expected) {
                row.pass(testResults);
            } else {
                row.fail(testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            if (this.expected) {
                row.error(testResults, e);
            }
            row.pass(testResults);
        }
    }

    public void setExpected(boolean expected) {
        this.expected = expected;
    }
}

