/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.definedAction.DefinedActionsRepository;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.workflow.caller.ValidCall;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PlainTextAnalyser {
    private final RuntimeContextInternal runtime;
    private final DefinedActionsRepository definedActionsRepository;

    public PlainTextAnalyser(RuntimeContextInternal runtime, DefinedActionsRepository definedActionsRepository) {
        this.runtime = runtime;
        this.definedActionsRepository = definedActionsRepository;
    }

    public void analyseAndReplaceRowsIn(Table table, TestResults testResults) {
        for (int r = 0; r < table.size(); ++r) {
            Row newRow = this.analyse((Row)table.at(r), testResults);
            table.replaceAt(r, newRow);
        }
    }

    private Row analyse(Row row, TestResults testResults) {
        String textCall = ((Cell)row.at(0)).fullText();
        ArrayList<ValidCall> results = new ArrayList<ValidCall>();
        this.definedActionsRepository.findPlainTextCall(textCall, results);
        if (results.isEmpty()) {
            ((Cell)row.at(0)).error(testResults, "Unknown action");
            return row;
        }
        this.removeShorterMatches(results);
        if (results.size() > 1) {
            ((Cell)row.at(0)).error(testResults, "Ambiguous action (see details in logs after table)");
            this.runtime.showAsAfterTable("plain text", "Possible action tables:<br/>");
            for (ValidCall call : results) {
                call.possibility(this.runtime.getGlobal());
            }
            return row;
        }
        Row newRow = TableFactory.row();
        for (String word : ((ValidCall)results.get(0)).getList()) {
            newRow.addCell(word);
        }
        return newRow;
    }

    private void removeShorterMatches(List<ValidCall> results) {
        int longest = 0;
        for (ValidCall call : results) {
            longest = Math.max(longest, call.getList().size());
        }
        Iterator<ValidCall> it = results.iterator();
        while (it.hasNext()) {
            if (it.next().getList().size() >= longest) continue;
            it.remove();
        }
    }
}

