/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fit.Fixture;
import fitlibrary.definedAction.ParameterBinder;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.runResults.TestResults;
import fitlibrary.runResults.TestResultsFactory;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.caller.DefinedActionCallManager;
import fitlibrary.traverse.workflow.caller.DefinedActionCaller;

public class MultiDefinedActionRunnerTraverse
extends Traverse {
    private ParameterBinder binder;
    private RuntimeContextInternal runtime;

    public MultiDefinedActionRunnerTraverse(ParameterBinder binder, RuntimeContextInternal runtime) {
        this.binder = binder;
        this.runtime = runtime;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            if (table.size() < 3) {
                throw new FitLibraryException("Missing data rows in table");
            }
            this.getRuntimeContext().pushLocalDynamicVariables();
            Row parameterRow = (Row)table.at(1);
            this.binder.verifyHeaderAgainstFormalParameters(parameterRow, this);
            parameterRow.pass(testResults);
            for (int r = 2; r < table.size(); ++r) {
                Row callRow = (Row)table.at(r);
                if (this.runtime.isAbandoned(testResults)) {
                    callRow.ignore(testResults);
                    continue;
                }
                try {
                    this.runRow(callRow, parameterRow, testResults);
                    continue;
                }
                catch (Exception e) {
                    callRow.error(testResults, e);
                }
            }
            this.getRuntimeContext().popLocalDynamicVariables();
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRow(Row callRow, Row parameterRow, TestResults testResults) {
        Tables body = this.binder.getCopyOfBody();
        TestResults subTestResults = TestResultsFactory.testResults();
        DefinedActionCallManager definedActionCallManager = this.runtime.getDefinedActionCallManager();
        try {
            definedActionCallManager.startCall(this.binder);
            this.binder.bindMulti(parameterRow, callRow, this.getDynamicVariables());
            this.runBody(body, subTestResults);
            this.colourRowInReport(callRow, testResults, subTestResults);
        }
        finally {
            definedActionCallManager.endCall(this.binder);
        }
        if (this.runtime.toExpandDefinedActions() || subTestResults.problems() || this.runtime.isAbandoned(testResults)) {
            Cell cell = TableFactory.cell(body);
            ((Table)cell.at(0)).setLeader(Fixture.label(DefinedActionCaller.link(this.binder.getPageName())));
            cell.calls();
            callRow.add(cell);
        } else if (definedActionCallManager.readyToShow()) {
            callRow.add(TableFactory.cell(TableFactory.tables(definedActionCallManager.getShowsTable())));
        }
    }

    private void runBody(Tables body, TestResults subTestResults) {
        TableEvaluator tableEvaluator = this.runtime.getTableEvaluator();
        tableEvaluator.runInnerTables(body, subTestResults);
    }

    private void colourRowInReport(Row callRow, TestResults testResults, TestResults subTestResults) {
        if (this.runtime.isAbandoned(testResults)) {
            callRow.ignore(testResults);
        } else if (this.runtime.toExpandDefinedActions() || subTestResults.problems()) {
            if (subTestResults.passed()) {
                callRow.passKeywords(testResults);
            } else if (subTestResults.errors()) {
                for (int i = 0; i < callRow.size(); ++i) {
                    ((Cell)callRow.at(i)).error(testResults, new FitLibraryException(""));
                }
            } else if (subTestResults.failed()) {
                for (int i = 0; i < callRow.size(); ++i) {
                    ((Cell)callRow.at(i)).fail(testResults);
                }
            } else {
                for (int i = 0; i < callRow.size(); ++i) {
                    ((Cell)callRow.at(i)).pass(testResults);
                }
            }
        } else {
            callRow.pass(testResults);
        }
    }
}

