/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.closure.ICalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.AbstractDoCaller;
import fitlibrary.traverse.workflow.caller.TwoStageSpecial;
import fitlibrary.typed.TypedObject;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.InvocationTargetException;

public class SpecialCaller
extends AbstractDoCaller {
    private String methodName;
    private ICalledMethodTarget specialMethod;
    private TwoStageSpecial twoStageSpecial = null;

    public SpecialCaller(Row row, Evaluator evaluator, LookupMethodTarget lookupTarget) {
        this.methodName = row.text(0, evaluator);
        this.specialMethod = lookupTarget.findSpecialMethod(evaluator, this.methodName);
        if (this.specialMethod != null && TwoStageSpecial.class.isAssignableFrom(this.specialMethod.getReturnType())) {
            try {
                this.twoStageSpecial = (TwoStageSpecial)this.specialMethod.invoke(new Object[]{row});
            }
            catch (InvocationTargetException e) {
                this.specialMethod = null;
                if (e.getCause() instanceof Exception) {
                    this.setProblem((Exception)e.getCause());
                }
            }
            catch (MissingMethodException e) {
                this.specialMethod = null;
                this.setProblem(e);
            }
            catch (Exception e) {
                this.specialMethod = null;
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.specialMethod != null;
    }

    @Override
    public TypedObject run(Row row, TestResults testResults) throws Exception {
        if (this.twoStageSpecial != null) {
            this.twoStageSpecial.run(testResults);
            return new GenericTypedObject(null);
        }
        return new GenericTypedObject(this.specialMethod.invoke(new Object[]{row, testResults}));
    }

    @Override
    public String ambiguityErrorMessage() {
        return "Special " + this.methodName + "(Row,TestResults) in " + this.specialMethod.getOwningClass().getName();
    }
}

