/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.caller;

import fitlibrary.traverse.workflow.caller.ValidCall;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class TestPlainTextForTableForDefinedAction
extends TestCase {
    public void testNone() {
        String[] stringArray = new String[]{""};
        this.suceeds("", "", stringArray);
    }

    public void testNoParameter() {
        String[] stringArray = new String[]{"<i>enters</i>"};
        this.suceeds("enters", "enters", stringArray);
    }

    public void testNoParameterAsSpecialChar() {
        String[] stringArray = new String[]{"<i>+*</i>"};
        this.suceeds("+*", "+*", stringArray);
    }

    public void testNoParameterAsSpecialChars() {
        String[] stringArray = new String[]{"<i>+ *</i>"};
        this.suceeds("+ *", "+ *", stringArray);
    }

    public void testNoParameterFailsAsMismatch() {
        this.fails("leaves", "enters");
    }

    public void testNoParameterFailsAsArgAtStart() {
        this.fails("anna enters", "enters");
    }

    public void testNoParameterButSeveralKeywords() {
        String[] stringArray = new String[]{"<i>enters the chat room</i>"};
        this.suceeds("enters the chat room", "enters the chat room", stringArray);
    }

    public void testOneArgAtEnd() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna"};
        this.suceeds("enters anna", "enters|", stringArray);
    }

    public void testOneArgAtStart() {
        String[] stringArray = new String[]{"", "anna", "<i>enters</i>"};
        this.suceeds("anna enters", "|enters", stringArray);
    }

    public void testOneArgAtStartWithSpecialChar() {
        String[] stringArray = new String[]{"", "anna", "<i>%</i>"};
        this.suceeds("anna %", "|%", stringArray);
    }

    public void testOneArgAtStartWithMissingArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>enters</i>", ""};
        this.suceeds("anna enters", "|enters|", stringArray);
    }

    public void testOneArgAtEndWithMissingArgs() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna", "", ""};
        this.suceeds("enters anna", "enters|||", stringArray);
    }

    public void testOneArgAtEndFailsAsExtraArgs() {
        this.fails("enters anna", "enters");
    }

    public void testOneKeywordWithTwoArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>leaves</i>", "lotr"};
        this.suceeds("anna leaves lotr", "|leaves|", stringArray);
    }

    public void testOneSpecialKeywordWithTwoArgs() {
        String[] stringArray = new String[]{"", "anna", "<i>*</i>", "lotr"};
        this.suceeds("anna * lotr", "|*|", stringArray);
    }

    public void testOneSpecialKeywordWithTwoArgsButOneMissingAfter() {
        String[] stringArray = new String[]{"", "anna", "<i>*</i>", ""};
        this.suceeds("anna *", "|*|", stringArray);
    }

    public void testOneSpecialKeywordWithTwoArgsButOneMissing() {
        String[] stringArray = new String[]{"<i>*</i>", "anna", "", ""};
        this.suceeds("* anna", "*|||", stringArray);
    }

    public void testSeveralArgsFromStart() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lotr", "<i>chat room</i>"};
        this.suceeds("anna enters the lotr chat room", "|enters the|chat room", stringArray);
    }

    public void testSeveralArgsFromStartWithUpperCase() {
        String[] stringArray = new String[]{"", "anna", "<i>enters The</i>", "lotr", "<i>chat Room</i>"};
        this.suceeds("anna enters The lotr chat Room", "|enters The|chat Room", stringArray);
    }

    public void testSeveralArgsNotFromStart() {
        String[] stringArray = new String[]{"<i>enters</i>", "anna", "<i>the</i>", "lotr", "<i>chat room</i>"};
        this.suceeds("enters anna the lotr chat room", "enters|the|chat room", stringArray);
    }

    public void testSeveralArgsWhereSomeArgsAreSeveralWords() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lord of the rings", "<i>chat room</i>"};
        this.suceeds("anna enters the lord of the rings chat room", "|enters the|chat room", stringArray);
    }

    public void testSeveralArgsWithNumber() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "lord of 4 rings", "<i>chat room</i>"};
        this.suceeds("anna enters the lord of 4 rings chat room", "|enters the|chat room", stringArray);
    }

    public void testSeveralArgsWithNumbers() {
        String[] stringArray = new String[]{"", "5", "<i>enters the</i>", "lord of 4 5 rings", "<i>chat room</i>"};
        this.suceeds("5 enters the lord of 4 5 rings chat room", "|enters the|chat room", stringArray);
    }

    public void testSeveralArgsWithLastMissing() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "", "<i>chat room</i>"};
        this.suceeds("anna enters the chat room", "|enters the|chat room", stringArray);
    }

    public void testSeveralArgsWithSeveralMissing() {
        String[] stringArray = new String[]{"", "anna", "<i>enters the</i>", "", "<i>chat room</i>", "", "", ""};
        this.suceeds("anna enters the chat room", "|enters the|chat room|||", stringArray);
    }

    public void testKeywordsFailToMatch() {
        this.fails("room", "entersTheChatRoom");
    }

    public void testSingleParameterFailsToMatchTwoArgs() {
        String string = "entersTheChatRoom";
        this.fails("anna enters the lotr chat room", string);
    }

    public void testWaimauku() {
        String[] stringArray = new String[]{"<i>address is at</i>", "Waimauku"};
        this.suceeds("address is at Waimauku", "address is at|", stringArray);
    }

    private void suceeds(String string, String string2, String[] stringArray) {
        TestPlainTextForTableForDefinedAction.assertEquals(Arrays.asList(stringArray), this.parse(string, string2));
    }

    private void fails(String string, String string2) {
        TestPlainTextForTableForDefinedAction.assertEquals(null, this.parse(string, string2));
    }

    private List<String> parse(String string, String string2) {
        ArrayList<ValidCall> arrayList = new ArrayList<ValidCall>();
        ValidCall.parseDefinedAction(string, string2, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        return ((ValidCall)arrayList.get(0)).getList();
    }
}

