/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.NotRejectedException;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import java.lang.reflect.InvocationTargetException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestNot {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    @Test
    public void trueWithFalseResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(1.returnValue((Object)false));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void trueWithException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(2.throwException((Throwable)new BadNumberException()));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void falseWithTrueResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(3.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NotRejectedException.class)
    public void exceptionWithNullResult() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(4.returnValue(null));
            }
        });
        this.globalActionScope.not(this.action);
    }

    @Test
    public void trueWithShowException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(5.throwException((Throwable)new InvocationTargetException(new FitLibraryShowException(new FitLibraryShowException.Show("abc")))));
                ((DoAction)this.one(TestNot.this.action)).show("abc");
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void trueWithIgnoredException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(6.throwException((Throwable)new IgnoredException()));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void trueAndShownWithIgnoredExceptionWithEmbedded() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(7.throwException((Throwable)new IgnoredException(new BadNumberException())));
                ((DoAction)this.one(TestNot.this.action)).show("Invalid Number");
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void trueWithOtherException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestNot.this.action)).runWithNoColouring();
                this.will(8.throwException((Throwable)new RuntimeException()));
            }
        });
        MatcherAssert.assertThat((Object)this.globalActionScope.not(this.action), (Matcher)CoreMatchers.is((Object)true));
    }
}

