/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class ExtendedCamelCase {
    static final String[] map = new String[]{"!", " bang ", "\"", " quote ", "#", " hash ", "$", " dollar ", "%", " percent ", "&", " ampersand ", "'", " single quote ", "(", " left parenthesis ", ")", " right parenthesis ", "*", " star ", "+", " plus ", ",", " comma ", "-", " minus ", ".", " dot ", "/", " slash ", ":", " colon ", ";", " semicolon ", "<", " less than ", ">", " greater than ", "=", " equals ", "?", " question ", "@", " at ", "[", " left square bracket ", "]", " right square bracket ", "\\", " backslash ", "^", " caret ", "`", " backquote ", "{", " left brace ", "}", " right brace ", "|", " bar ", "~", " tilde "};
    private static final String[] javaKeyWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final Set<String> javaKeywordSet = new HashSet<String>();

    @Deprecated
    public static String camel(String s) {
        return ExtendedCamelCase.camel(s, false);
    }

    public static String camel(String nameInitial, boolean keepUnicode) {
        String name = nameInitial.trim();
        if (name.length() == 0) {
            return "blank";
        }
        for (int i = 0; i < map.length; i += 2) {
            int pos;
            String from = map[i];
            String to = map[i + 1];
            while ((pos = name.indexOf(from)) >= 0) {
                name = name.substring(0, pos) + to + name.substring(pos + from.length());
            }
        }
        if (Character.isDigit(name.charAt(0))) {
            name = ExtendedCamelCase.mapNumber(name.charAt(0)) + name.substring(1);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return ExtendedCamelCase.hideJavaKeyword(ExtendedCamelCase.translateUnicode(ExtendedCamelCase.camelise(name), keepUnicode));
    }

    public static String camelClassName(String className, boolean keepUnicode) {
        if (className.indexOf(" ") < 0) {
            return className;
        }
        return ExtendedCamelCase.camel("t " + className, keepUnicode).substring(1);
    }

    private static String camelise(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name);
        String result = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result = result + token.substring(0, 1).toUpperCase() + token.substring(1);
        }
        return result;
    }

    private static String hideJavaKeyword(String name) {
        if (javaKeywordSet.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private static String translateUnicode(String name, boolean keepUnicode) {
        StringBuffer b = new StringBuffer(name.length());
        if (!name.isEmpty()) {
            char ch = name.charAt(0);
            if (ch < '\u0080' || keepUnicode && Character.isJavaIdentifierStart(ch)) {
                b.append(ch);
            } else {
                b.append("u" + Integer.toHexString(ch).toUpperCase());
            }
        }
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch < '\u0080' || keepUnicode && Character.isJavaIdentifierPart(ch)) {
                b.append(ch);
                continue;
            }
            b.append("u" + Integer.toHexString(ch).toUpperCase());
        }
        return b.toString();
    }

    private static String mapNumber(char c) {
        switch (c) {
            case '0': {
                return "zero ";
            }
            case '1': {
                return "one ";
            }
            case '2': {
                return "two ";
            }
            case '3': {
                return "three ";
            }
            case '4': {
                return "four ";
            }
            case '5': {
                return "five ";
            }
            case '6': {
                return "six ";
            }
            case '7': {
                return "seven ";
            }
            case '8': {
                return "eight ";
            }
            case '9': {
                return "nine ";
            }
        }
        return "" + c;
    }

    static {
        for (int i = 0; i < javaKeyWords.length; ++i) {
            javaKeywordSet.add(javaKeyWords[i]);
        }
    }
}

