/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fitlibrary.runtime.RuntimeContextContainer;
import fitlibrary.runtime.RuntimeContextInternal;
import junit.framework.TestCase;

public class TestDynamicVariables
extends TestCase {
    private RuntimeContextInternal varEmpty;
    private RuntimeContextInternal varFull;

    public void setUp() {
        this.varEmpty = new RuntimeContextContainer();
        String[] stringArray = new String[]{"a", "A", "b", "B"};
        this.varFull = new RuntimeContextContainer(stringArray);
    }

    public void testEmptyString() {
        TestDynamicVariables.assertEquals((String)"", (String)((String)this.varEmpty.getDynamicVariables().resolve((String)"").first));
        TestDynamicVariables.assertEquals((String)"", (String)((String)this.varFull.getDynamicVariables().resolve((String)"").first));
    }

    public void testMatchSingle() {
        TestDynamicVariables.assertEquals((String)"@{a}", (String)((String)this.varEmpty.getDynamicVariables().resolve((String)"@{a}").first));
        TestDynamicVariables.assertEquals((String)"A", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}").first));
    }

    public void testMatchDouble() {
        TestDynamicVariables.assertEquals((String)"@{a}@{b}", (String)((String)this.varEmpty.getDynamicVariables().resolve((String)"@{a}@{b}").first));
        TestDynamicVariables.assertEquals((String)"AB", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}@{b}").first));
    }

    public void testInfinite() {
        this.varFull.getDynamicVariables().put("a", "@{a}");
        TestDynamicVariables.assertEquals((String)"INFINITE SUBSTITUTION!", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}").first));
    }

    public void testInfinite2() {
        this.varFull.getDynamicVariables().put("a", "@{a}A");
        TestDynamicVariables.assertEquals((String)"INFINITE SUBSTITUTION!", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}").first));
    }

    public void testDoubleSubstitution() {
        this.varFull.getDynamicVariables().put("a", "@{b}");
        TestDynamicVariables.assertEquals((String)"BBBBBBB", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}@{a}@{a}@{a}@{a}@{a}@{a}").first));
    }

    public void testFourSubstitutions() {
        this.varFull.getDynamicVariables().put("a", "@{b}A");
        this.varFull.getDynamicVariables().put("b", "@{c}B");
        this.varFull.getDynamicVariables().put("c", "@{d}C");
        this.varFull.getDynamicVariables().put("d", "D");
        TestDynamicVariables.assertEquals((String)"DCBA", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{a}").first));
    }

    public void testMatchSingleA() {
        TestDynamicVariables.assertEquals((String)"@{@{a}}", (String)((String)this.varEmpty.getDynamicVariables().resolve((String)"@{@{a}}").first));
        this.varFull.getDynamicVariables().put("a", "b");
        TestDynamicVariables.assertEquals((String)"B", (String)((String)this.varFull.getDynamicVariables().resolve((String)"@{@{a}}").first));
    }

    public void testMatchOutOfSystemProperties() {
        System.getProperties().put("a", "A");
        TestDynamicVariables.assertEquals((String)"A", (String)((String)new RuntimeContextContainer().getDynamicVariables().resolve((String)"@{a}").first));
    }
}

