/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fit.Parse;
import fitlibrary.utility.ParseUtility;
import java.text.ParseException;
import junit.framework.TestCase;

public class TestParseUtility
extends TestCase {
    private static final String html = "<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
    private static String setUpHtml = "<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4</body></html>";
    private static String tearDownHtml = "<html><title>teardown</title><body>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
    private Parse tables;
    private Parse setUp;
    private Parse tearDown;

    public void setUp() throws ParseException {
        this.tables = new Parse(html);
        this.setUp = new Parse(setUpHtml);
        this.tearDown = new Parse(tearDownHtml);
    }

    public void testAppend() {
        String string = "<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        ParseUtility.append(this.setUp, this.tearDown);
        this.assertEquals(string, this.setUp);
    }

    public void testAppendNull() {
        ParseUtility.append(this.setUp, null);
        this.assertEquals(setUpHtml, this.setUp);
    }

    public void testAppendSetUp() {
        String string = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
        ParseUtility.appendToSetUp(this.setUp, this.tables);
        this.assertEquals(string, this.setUp);
    }

    public void testAppendSetUpWithNull() {
        ParseUtility.appendToSetUp(this.setUp, null);
        this.assertEquals(setUpHtml, this.setUp);
    }

    public void testAppendAll() {
        String string = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        ParseUtility.append(this.tables, this.tearDown);
        ParseUtility.appendToSetUp(this.setUp, this.tables);
        this.assertEquals(string, this.setUp);
    }

    private void assertEquals(String string, Parse parse) {
        TestParseUtility.assertEquals((String)string, (String)ParseUtility.toString(parse));
    }

    public void testFixHeader() {
        String string = ParseUtility.removeHeader(this.tables);
        TestParseUtility.assertEquals((String)"<html><title>table</title><body>", (String)string);
        this.assertEquals("t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }

    public void testInitialTable() {
        this.assertEquals(html, this.tables);
    }

    public void testChangeHeader() {
        ParseUtility.changeHeader(this.tables, "<html><title>new</title><body><hr>");
        this.assertEquals("<html><title>new</title><body><hr>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }

    public void testCompleteTrailerThatIsComplete() {
        ParseUtility.completeTrailer(this.tables);
        this.assertEquals(html, this.tables);
    }

    public void testCompleteTrailerThatIsInComplete() {
        this.tables.last().trailer = "JUNK";
        ParseUtility.completeTrailer(this.tables);
        this.assertEquals("<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>JUNK\n</body></html>\n", this.tables);
    }

    public void testFixTrailersNone() throws ParseException {
        String string = "<html><title>setup</title><body><table><tr><td>SetUp</td></tr></table></body></html>";
        Parse parse = new Parse(string);
        ParseUtility.fixTrailers(parse, this.tables);
        this.assertEquals("<html><title>setup</title><body><table><tr><td>SetUp</td></tr></table>", parse);
        this.assertEquals(html, this.tables);
    }

    public void testFixTrailers() {
        ParseUtility.removeHeader(this.tables);
        ParseUtility.fixTrailers(this.setUp, this.tables);
        this.assertEquals("<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>", this.setUp);
        this.assertEquals("s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }

    public void testOneTableWithOneActionTranslated() {
        String string = "<html>\n<br/>* <i>One</i><br/>\nt2\n</html>";
        String string2 = "<html>\n\n<table><tr><td><i>One</i></td></tr></table>\n\nt2\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }

    public void testTwoTablesWithOneActionTranslated() {
        String string = "<html>\n<br/>* <i>One</i><br/>\n<br/>* <i>Two</i><br/>\n</html>";
        String string2 = "<html>\n\n<table><tr><td><i>One</i></td></tr></table>\n\n\n<table><tr><td><i>Two</i></td></tr></table>\n\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }

    public void testOneTableWithOneActionWithSeveralKeywords() {
        String string = "<html>\n<br/>* <i>one</i>two<i>three</i><br/>\n</html>";
        String string2 = "<html>\n\n<table><tr><td><i>one</i></td><td>two</td><td><i>three</i></td></tr></table>\n\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }

    public void testWithNL() {
        String string = "<html>\n\n* <i>one</i>two<i>three</i>\n</html>";
        String string2 = "<html>\n\n<table><tr><td><i>one</i></td><td>two</td><td><i>three</i></td></tr></table>\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }

    public void testOneTableWithOneActionWithSeveralKeywordsBold() {
        String string = "<html>\n<br/>* <i>one</i>two<b>is</b>1<br/>\n</html>";
        String string2 = "<html>\n\n<table><tr><td><i>one</i></td><td>two</td><td><b>is</b></td><td>1</td></tr></table>\n\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }

    public void testOneTableWithBold() {
        String string = "<html>\n<br/>* <b>one</b> <i>two</i> 1<br/>\n</html>";
        String string2 = "<html>\n\n<table><tr><td><b>one</b></td><td><i>two</i></td><td>1</td></tr></table>\n\n</html>";
        TestParseUtility.assertEquals((String)string2, (String)ParseUtility.translate(string));
    }
}

