/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.xref;

import fit.exception.FitParseException;
import fitlibrary.batch.fitnesseIn.ParallelFitNesseRepository;
import fitlibrary.batch.trinidad.TestDescriptor;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;

public class CrossReferenceFixture
extends Traverse {
    private String suiteName;
    private Map<String, Set<String>> xref = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> definedActions = new TreeMap<String, Set<String>>();

    public CrossReferenceFixture(String suiteName) {
        this.suiteName = suiteName.substring(1);
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        try {
            TestDescriptor test;
            ParallelFitNesseRepository parallelFitNesseRepository = new ParallelFitNesseRepository(this.fitNesseDiry());
            BlockingQueue<TestDescriptor> queue = parallelFitNesseRepository.getSuite(this.suiteName);
            while (!ParallelFitNesseRepository.isSentinel(test = queue.take())) {
                String html = test.getContent();
                if (!html.contains("<table")) continue;
                this.xref(test.getName(), TableFactory.tables(html));
            }
            table.add(TableFactory.row("<h1>Action calls</h1>", "(The ones that start with ~ may be due to data rows)"));
            this.addMapDataToTable(this.xref, table);
            if (!this.definedActions.isEmpty()) {
                table.add(TableFactory.row("<h1>Defined Actions</h1>", ""));
            }
            this.addMapDataToTable(this.definedActions, table);
            ((Cell)((Row)table.at(0)).at(0)).pass(testResults);
        }
        catch (Exception e) {
            ((Cell)((Row)table.at(0)).at(0)).error(testResults, e);
        }
        return null;
    }

    protected String fitNesseDiry() {
        return ".";
    }

    private void xref(String pageName, Tables tables) throws FitParseException, InterruptedException, IOException {
        for (Table table : tables) {
            for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                String action = this.actionOf((Row)table.at(rowNo), this.getRuntimeContext());
                if (action == null) continue;
                this.add(this.xref, action, pageName, rowNo == 0);
            }
        }
    }

    private void add(Map<String, Set<String>> map, String originalActionName, String pageName, boolean firstRow) {
        if (!firstRow && this.onlyNumbers(originalActionName)) {
            return;
        }
        if (originalActionName.equals("") || originalActionName.equals("actions") || originalActionName.equals("checks") || originalActionName.equals("get")) {
            return;
        }
        if (pageName.equals("")) {
            return;
        }
        String actionName = originalActionName;
        Set<String> set = map.get(actionName);
        if (set == null) {
            if (firstRow) {
                set = map.get("~ " + actionName);
                if (set != null) {
                    map.put(actionName, set);
                    map.remove("~ " + actionName);
                }
            } else {
                actionName = "~ " + actionName;
                set = map.get(actionName);
            }
        }
        if (set == null) {
            set = new TreeSet<String>();
            map.put(actionName, set);
        }
        set.add(pageName);
    }

    private boolean onlyNumbers(String name) {
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (this.numberChar(charArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean numberChar(char ch) {
        return Character.isDigit(ch) || ch == '.' || ch == ' ';
    }

    private String actionOf(Row row, RuntimeContextInternal runtime) throws FitParseException, InterruptedException, IOException {
        String first;
        int start = 0;
        int pastEnd = row.size();
        if (this.ignoreThisAction(pastEnd, first = this.runtimeContext.extendedCamel(row.text(0, this)))) {
            return null;
        }
        if (pastEnd == 2 && first.equals("defineActionsAt")) {
            this.processDefinedActions(row.text(1, this));
            return null;
        }
        if (this.postFixWithValue(this.postFixActionName(row, pastEnd, runtime))) {
            pastEnd -= 2;
        } else if (first.equals("check")) {
            ++start;
            --pastEnd;
        } else if (this.prefixWithOneArg(first)) {
            ++start;
        } else if (first.equals("oo")) {
            start += 2;
        } else if (first.equals("set")) {
            start += 2;
        } else if (first.equals("show after")) {
            ++start;
        }
        String result = "";
        for (int i = start; i < pastEnd; i += 2) {
            result = result + " " + row.text(i, this);
        }
        return result.trim();
    }

    private String postFixActionName(Row row, int pastEnd, RuntimeContextInternal runtime) {
        if (pastEnd > 2) {
            return runtime.extendedCamel(row.text(pastEnd - 2, this));
        }
        return "";
    }

    private boolean ignoreThisAction(int pastEnd, String first) {
        if (pastEnd == 1) {
            return first.equals("comment") || first.equals("ignore") || first.equals("ignored") || first.equals("ignoreTable");
        }
        return first.equals("expectedTestResults") || first.equals("note");
    }

    private boolean postFixWithValue(String first) {
        return first.equals("is") || first.equals("is not") || first.equals("matches") || first.equals("doesNotMatch") || first.equals("becomes");
    }

    private boolean prefixWithOneArg(String first) {
        return first.equals("not") || first.equals("reject") || first.equals("log") || first.equals("ensure") || first.equals("show") || first.equals("showDot");
    }

    private void processDefinedActions(String definitionsName) throws InterruptedException, IOException, FitParseException {
        TestDescriptor test;
        ParallelFitNesseRepository parallelFitNesseRepository = new ParallelFitNesseRepository(".");
        BlockingQueue<TestDescriptor> queue = parallelFitNesseRepository.getDefinedActions(definitionsName);
        while (!ParallelFitNesseRepository.isSentinel(test = queue.take())) {
            String html = test.getContent();
            if (!html.contains("<table")) continue;
            Tables tables = TableFactory.tables(html);
            boolean header = true;
            for (Table table : tables) {
                String pageName = definitionsName + "." + test.getName();
                if (pageName.endsWith(".")) {
                    pageName = definitionsName;
                }
                if (header) {
                    this.add(this.definedActions, this.actionOf((Row)table.at(0), this.getRuntimeContext()), pageName, true);
                    header = false;
                    continue;
                }
                for (int rowNo = 0; rowNo < table.size(); ++rowNo) {
                    String action = this.actionOf((Row)table.at(rowNo), this.getRuntimeContext());
                    if (action == null) continue;
                    this.add(this.xref, action, pageName, rowNo == 0);
                }
                if (table.getTrailer() == null || !table.getTrailer().contains("<hr/>")) continue;
                header = true;
            }
        }
    }

    private void addMapDataToTable(Map<String, Set<String>> map, Table table) {
        for (String key : map.keySet()) {
            String list = "";
            for (String page : map.get(key)) {
                list = list + ", <a href=\"" + page + "\">" + page + "</a>";
            }
            table.add(TableFactory.row(key, list.substring(2)));
        }
    }
}

