/*
 * Decompiled with CFR 0.152.
 */
package fitlibraryGeneric.list;

import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.collection.array.ArraySetUpTraverse;
import fitlibrary.collection.array.ArrayTraverse;
import fitlibrary.collection.list.ListTraverse;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.parser.Parser;
import fitlibrary.parser.collection.ListParser;
import fitlibrary.parser.lookup.ParserFactory;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Table;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.Typed;
import fitlibraryGeneric.generic.GenericTypeUtility;
import fitlibraryGeneric.list.ListSetUpTraverse2;
import fitlibraryGeneric.list.NestingListSetUpTraverse;
import fitlibraryGeneric.list.NestingListTraverse;
import fitlibraryGeneric.typed.GenericTyped;
import fitlibraryGeneric.typed.GenericTypedObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListParser2
extends ListParser {
    private GenericTyped componentTyped;

    public ListParser2(Evaluator evaluator, GenericTyped typed) {
        super(evaluator, typed);
        this.componentTyped = typed.getComponentTyped();
        if (this.componentTyped.typeCases() == GenericTypeUtility.GenericCases.CLASS_TYPE) {
            this.valueParser = this.showParser = this.componentTyped.resultParser(evaluator);
        }
    }

    @Override
    protected List<Object> parseTable(Table table, TestResults testResults) {
        switch (this.componentTyped.typeCases()) {
            case CLASS_TYPE: {
                if (this.componentTyped.isEffectivelyPrimitive() || this.componentTyped.isEnum()) {
                    ArraySetUpTraverse setUpTraverse = new ArraySetUpTraverse(this.componentTyped.asClass(), this.componentTyped.parser(this.evaluator));
                    setUpTraverse.setRuntimeContext(this.evaluator.getRuntimeContext());
                    setUpTraverse.interpretAfterFirstRow(table, testResults);
                    Object array = setUpTraverse.getResults();
                    ArrayList<Object> result = new ArrayList<Object>();
                    for (int i = 0; i < Array.getLength(array); ++i) {
                        result.add(Array.get(array, i));
                    }
                    return result;
                }
                if (this.componentTyped.isArray()) {
                    return this.parseNested(table, testResults);
                }
                if (CollectionSetUpTraverse.hasObjectFactoryMethodFor(table, this.evaluator)) {
                    return super.parseTable(table, testResults);
                }
                ListSetUpTraverse2 setUp = new ListSetUpTraverse2(this.componentTyped.asClass());
                setUp.interpretWithinScope(table, this.evaluator.getRuntimeContext(), testResults);
                return setUp.getResults();
            }
            case PARAMETERIZED_TYPE: {
                return this.parseNested(table, testResults);
            }
        }
        throw new FitLibraryException("Type not sufficiently bound: " + this.componentTyped);
    }

    private List<Object> parseNested(Table table, TestResults testResults) {
        NestingListSetUpTraverse nestedSetUp = new NestingListSetUpTraverse(this.componentTyped);
        nestedSetUp.interpretWithinScope(table, this.evaluator.getRuntimeContext(), testResults);
        return nestedSetUp.getResults();
    }

    @Override
    protected boolean tableMatches(Table table, Object initialResult, TestResults testResults) {
        List<Object> result = initialResult;
        List<Object> listResult = null;
        if (result instanceof List) {
            listResult = result;
        } else if (result.getClass().isArray()) {
            listResult = Arrays.asList((Object[])result);
        } else {
            throw new FitLibraryException("Unable to treat object as list: " + result.getClass());
        }
        switch (this.componentTyped.typeCases()) {
            case CLASS_TYPE: {
                if (this.componentTyped.isEffectivelyPrimitive() || this.componentTyped.isEnum()) {
                    Object arrayResult = Array.newInstance(this.componentTyped.asClass(), listResult.size());
                    for (int i = 0; i < listResult.size(); ++i) {
                        Array.set(arrayResult, i, listResult.get(i));
                    }
                    ArrayTraverse arrayTraverse = new ArrayTraverse(new GenericTypedObject(arrayResult, new GenericTyped(arrayResult.getClass())));
                    return arrayTraverse.doesInnerTablePass(table, this.evaluator.getRuntimeContext(), testResults);
                }
                if (result.getClass().isArray()) {
                    result = Arrays.asList((Object[])result);
                }
                if (!this.componentTyped.isArray()) {
                    ListTraverse listTraverse = new ListTraverse((Object)null);
                    listTraverse.setActualCollection(listResult);
                    listTraverse.setComponentType(this.componentTyped.asClass());
                    return listTraverse.doesInnerTablePass(table, this.evaluator.getRuntimeContext(), testResults);
                }
            }
            case PARAMETERIZED_TYPE: {
                if (result.getClass().isArray()) {
                    result = Arrays.asList((Object[])result);
                }
                NestingListTraverse nestingList = new NestingListTraverse(result, this.componentTyped);
                return nestingList.doesTablePass(table, this.evaluator.getRuntimeContext(), testResults);
            }
        }
        throw new FitLibraryException("Type not sufficiently bound: " + this.componentTyped);
    }

    public static ParserFactory parserFactory() {
        return new ParserFactory(){

            @Override
            public Parser parser(Evaluator evaluator, Typed typed) {
                GenericTyped genericTyped;
                if (typed instanceof GenericTyped && ((genericTyped = (GenericTyped)typed).isGeneric() || genericTyped.isArray())) {
                    return new ListParser2(evaluator, genericTyped);
                }
                return new ListParser(evaluator, typed);
            }
        };
    }
}

