/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.definedactions;

import fitlibrary.DoFixture;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.log.FixturingLogger;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class GreaseMonkeyDefinedActionLister
extends DoFixture {
    static Logger logger = FixturingLogger.getLogger(GreaseMonkeyDefinedActionLister.class);

    public boolean showAndListDefinedActionsForGreaseMonkey(File pathToDefinedActionsDir) {
        StringBuilder builder = new StringBuilder();
        GreaseMonkeyDefinedActionLister lister = new GreaseMonkeyDefinedActionLister();
        try {
            for (String line : lister.listDefinedActions(pathToDefinedActionsDir)) {
                builder.append(line);
                builder.append("<br/>");
            }
            this.showAfterTable(builder.toString());
            return true;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return false;
        }
    }

    private boolean isSpiderFixtureCommand(String action) {
        return action.equals("click") || action.equals("get url");
    }

    public List<String> listDefinedActions(File pathToDefinedActionsDir) throws IOException {
        ArrayList<String> returnList = new ArrayList<String>();
        String[] extensions = new String[]{"txt"};
        Iterator<File> i = this.createDirectoryIterator(extensions, pathToDefinedActionsDir);
        block0: while (i.hasNext()) {
            File file = i.next();
            Iterator l = this.createLineListerForFile(file);
            boolean nextLineIsSignature = true;
            while (l.hasNext()) {
                String line = (String)l.next();
                if ((line = line.trim()).startsWith("!contents")) continue block0;
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("----")) {
                    nextLineIsSignature = true;
                    continue;
                }
                if (!nextLineIsSignature || (line = this.extractDefinedActionNameFromTable(line)) == null) continue;
                nextLineIsSignature = false;
                if (this.isSpiderFixtureCommand(line)) continue;
                String path = this.convertFilePathToFitnesseLink(file);
                String javaScript = MessageFormat.format("definedActions[''{0}''] = \"{1}\";", line, path);
                if (returnList.contains(javaScript)) {
                    System.err.println("note: duplicate defiend action (probably due to same name with multiple parameters), already generated: " + javaScript);
                }
                returnList.add(javaScript);
            }
        }
        return returnList;
    }

    private String extractDefinedActionNameFromTable(String lineInitial) {
        String line = lineInitial;
        line = line.replace("'''", "");
        line = line.replace("''", "");
        int posofSecondBar = line.indexOf("|", 1);
        if (line.startsWith("|") || posofSecondBar > 0) {
            line = line.substring(1, posofSecondBar).toLowerCase();
            return line.trim();
        }
        return null;
    }

    private String convertFilePathToFitnesseLink(File file) {
        String path = file.getPath();
        int indexOfFitNesseRoot = path.indexOf("FitNesseRoot");
        int indexOfContent = path.indexOf("\\content.txt");
        if (indexOfContent == -1 || indexOfFitNesseRoot == -1) {
            throw new FitLibraryException("Cannot find either FitNesseRoot or content.txt in file path [" + path + "].");
        }
        path = path.substring(indexOfFitNesseRoot + 13, indexOfContent);
        path = path.replace('\\', '.');
        path = "/" + path;
        return path;
    }

    protected Iterator createLineListerForFile(File file) throws IOException {
        return FileUtils.lineIterator((File)file);
    }

    protected Iterator<File> createDirectoryIterator(String[] extensions, File pathToDefinedActionsDir) {
        return FileUtils.iterateFiles((File)pathToDefinedActionsDir, (String[])extensions, (boolean)true);
    }
}

