/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.responder;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.mockWebServices.responder.SimpleResponder;
import fitlibrary.ws.message.ContentType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FileResponder
extends SimpleResponder {
    private String fileName;

    public FileResponder(String fileName, ContentType responseContentType) {
        super(responseContentType);
        this.fileName = fileName;
        if (!new File(fileName).exists()) {
            throw new FitLibraryException("File doesn't exist: " + fileName);
        }
    }

    @Override
    public String getContents() {
        try {
            return this.readFile();
        }
        catch (IOException e) {
            return "Problem reading file '" + this.fileName + "': " + e.getMessage();
        }
    }

    private String readFile() throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.fileName)));
        String result = "";
        while ((line = reader.readLine()) != null) {
            result = String.valueOf(result) + line;
        }
        reader.close();
        return result;
    }

    @Override
    public boolean isOK() {
        return true;
    }
}

