/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.server;

import fitlibrary.log.FixturingLogger;
import fitlibrary.server.AbstractHttpRequestHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.activation.MimetypesFileTypeMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.FileEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpFileHandler
extends AbstractHttpRequestHandler {
    private static Logger logger = FixturingLogger.getLogger(HttpFileHandler.class);
    private final File docRoot;

    public HttpFileHandler(String docRoot) {
        this.docRoot = new File(docRoot);
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String fileName;
        File file;
        logger.trace((Object)("Received request: " + request.getRequestLine()));
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
            throw new MethodNotSupportedException(String.valueOf(method) + " method not supported");
        }
        String target = request.getRequestLine().getUri();
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            byte[] entityContent = EntityUtils.toByteArray((HttpEntity)entity);
            logger.trace((Object)("Incoming entity content (bytes): " + entityContent.length));
        }
        if (!(file = new File(this.docRoot, fileName = URLDecoder.decode(target, "utf-8"))).exists() || this.attemptToEscapeDirectory(file)) {
            this.errorInHtmlH1(response, 404, "File " + file.getPath() + " not found in " + this.docRoot.getPath());
        } else if (!file.canRead() || file.isDirectory()) {
            this.errorInHtmlH1(response, 403, "Access denied: File is a directory or cannot be read: " + file.getPath());
        } else {
            response.setStatusCode(200);
            String contentType = String.valueOf(this.mime(fileName)) + "; charset=UTF-8";
            logger.trace((Object)("Reply Content-type: " + contentType));
            FileEntity body = new FileEntity(file, contentType);
            response.setEntity((HttpEntity)body);
            logger.trace((Object)("Serving file " + file.getPath()));
        }
    }

    private boolean attemptToEscapeDirectory(File file) {
        return !file.getAbsolutePath().startsWith(this.docRoot.getAbsolutePath());
    }

    private String mime(String fileName) {
        return new MimetypesFileTypeMap().getContentType(fileName);
    }
}

