/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.component;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.spider.SpiderFixture;
import fitlibrary.spider.component.SpiderComponent;
import fitlibrary.spider.polling.PollForMatches;
import fitlibrary.spider.utility.HtmlTextUtility;
import java.util.regex.Pattern;

public class TextInPage
extends SpiderComponent {
    public TextInPage(SpiderFixture spiderFixture) {
        super(spiderFixture);
    }

    public boolean pageContainsText(final String text) {
        try {
            boolean match = this.ensureMatches(new PollForMatches(){

                @Override
                public boolean matches() {
                    return TextInPage.this.passed(HtmlTextUtility.crLfRemoved(TextInPage.this.pageSource()).contains(text), text, text);
                }
            });
            this.showAfterTable("This action is deprecated. Instead, use: " + this.deprecate("<i>page source</i>", "<b>contains</b>", text));
            return match;
        }
        catch (NullPointerException e) {
            throw this.problem("Unavailable", text);
        }
    }

    private String deprecate(String ... ss) {
        String result = "<table><tr>";
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result = String.valueOf(result) + "<td>" + s + "</td>";
            ++n2;
        }
        return String.valueOf(result) + "</tr></table>";
    }

    public boolean pageContainsTextIgnoreHtmlBreakingTokens(final String text) {
        try {
            boolean ensureMatches = this.ensureMatches(new PollForMatches(){

                @Override
                public boolean matches() {
                    String src = TextInPage.this.pageSourceCleaned();
                    return TextInPage.this.passed(src.contains(text), text, text);
                }
            });
            this.showAfterTable("This action is deprecated. Instead, use: " + this.deprecate("<i>page source cleaned</i>", "<b>eventually matches</b>", text));
            return ensureMatches;
        }
        catch (NullPointerException e) {
            throw this.problem("Unavailable", text);
        }
    }

    public boolean pageContainsRegularExpression(final String regEx) {
        boolean ensureMatches = this.ensureMatches(new PollForMatches(){

            @Override
            public boolean matches() {
                return TextInPage.this.patternMatchesAcrossLines(TextInPage.this.pageSource(), regEx);
            }
        });
        this.showAfterTable("This action is deprecated. Instead, use: " + this.deprecate("<i>page source</i>", "<b>eventually matches</b>", regEx));
        return ensureMatches;
    }

    public String pageSubstringFromTo(String prior, String subsequent) {
        String src = this.pageSource();
        int start = src.indexOf(prior);
        if (start < 0) {
            return "";
        }
        int end = src.indexOf(subsequent, start += prior.length());
        if (end < 0) {
            return "";
        }
        return src.substring(start, end);
    }

    public String pageSource() {
        try {
            return HtmlTextUtility.crLfRemoved(this.webDriver().getPageSource());
        }
        catch (Exception e) {
            return "<i>Page Source is unavailable</i>";
        }
    }

    public String pageSourceCleaned() {
        return HtmlTextUtility.spacesToSingleSpace(HtmlTextUtility.brToSpace(HtmlTextUtility.nonBreakingSpaceToSpace(this.pageSource())));
    }

    protected boolean patternMatchesAcrossLines(String text, String regEx) {
        return Pattern.compile(".*" + regEx + ".*", 32).matcher(text).matches();
    }

    protected boolean passed(boolean passed, String expected, String resolvedTitle) {
        if (passed) {
            return true;
        }
        if (expected.equals(resolvedTitle)) {
            return false;
        }
        throw new FitLibraryException("Failed with: '" + resolvedTitle + "'");
    }
}

