/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spider.utility;

import org.openqa.selenium.WebElement;

public class WebElementIdentifier {
    private final WebElement element;
    private final String tag;
    private String comma = "";

    public WebElementIdentifier(WebElement element, String tag) {
        this.element = element;
        this.tag = tag;
    }

    public String identify() {
        String text;
        StringBuilder s = new StringBuilder();
        s.append("<" + this.tag);
        String attributes = this.addAttributes();
        if (!"".equals(attributes)) {
            s.append(" ");
            s.append(attributes);
        }
        if (!"".equals(text = this.element.getText())) {
            s.append(">");
            s.append(text);
            s.append("</" + this.tag + ">");
        } else {
            s.append("/>");
        }
        return s.toString();
    }

    private String addAttributes() {
        String[] attrs;
        this.comma = "";
        StringBuilder s = new StringBuilder();
        this.addUnless(s, "name", this.element.getTagName(), this.tag);
        this.addAttribute(s, "id");
        String attributes = "abbr accept accept-charset accesskey action align alt archive axis bgcolor border cellpadding cellspacing char charoff charset checked/false class classid codebase codetype cols colspan compact content coords data declare dir disabled/false enctype frame frameborder headers heigth hspace href hreflang hspace http-equiv label lang longdesc marginheight marginwidth maxlength media method multiple noresize noshade nowrap onclick ondblclick onmousedown onmousemove onmouseout onmouseover onmouseup onkeydown onkeypress onkeyup onload onunload readonly/false rel rev rows rowspan rules scheme scope scrolling shape size src standby start style summary tabindex target title type usemap valign valuetype vspace width xml:lang yalign";
        String[] stringArray = attrs = attributes.split(" ");
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            String[] split = attributeName.split("/");
            if (split.length == 1) {
                this.addAttribute(s, attributeName);
            } else {
                int i = 1;
                while (i < split.length) {
                    this.addUnless(s, split[0], split[i].replace("_", " "));
                    ++i;
                }
            }
            ++n2;
        }
        this.addUnless(s, "value", this.element.getAttribute("value"), "Submit Query");
        this.addUnless(s, "enabled", "" + this.element.isEnabled(), "true");
        try {
            this.addUnless(s, "selected", "" + this.element.isSelected(), "false");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private void addAttribute(StringBuilder s, String attributeName) {
        this.add(s, attributeName, this.element.getAttribute(attributeName));
    }

    private void add(StringBuilder s, String attributeName, String value) {
        if (value != null && !"".equals(value)) {
            s.append(String.valueOf(this.comma) + attributeName + "='" + value + "'");
            this.comma = ", ";
        }
    }

    private void addUnless(StringBuilder s, String attributeName, String unless) {
        String value = this.element.getAttribute(attributeName);
        if (value != null && !value.equals(unless)) {
            s.append(String.valueOf(this.comma) + attributeName + "='" + value + "'");
            this.comma = ", ";
        }
    }

    private void addUnless(StringBuilder s, String attributeName, String value, String unless) {
        if (value != null && !value.equals(unless)) {
            s.append(String.valueOf(this.comma) + attributeName + "='" + value + "'");
            this.comma = ", ";
        }
    }
}

